package com.rocogz.syy.settlement.dto;

import com.rocogz.syy.settlement.constant.SettlementConstant;
import com.rocogz.syy.settlement.enums.AccountTradeRecordTypeEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author djt
 * @date 2021/4/9
 */
@Data
public class UpdateAccountParamDTO {

    /**
     * 账户编号
     */
    private String acctNo;

    /**
     *
     */
    private String acctType;

    /**
     * 业务编号
     */
    private String businessNo;

    /**
     * 更改金额
     */
    private BigDecimal amount;

    /**
     * 总额度
     */
    private BigDecimal totalAmount;

    /**
     * 可用额度或未划拨额度
     */
    private BigDecimal balanceAmount;

    /**
     * 已用金额或已划拨额度
     */
    private BigDecimal usedAmount;

    /**
     * 已发放金额
     */
    private BigDecimal issuedAmount;

    /**
     * 已领取金额
     */
    private BigDecimal receivedAmount;

    /**
     * 已退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 已冻结额度
     */
    private BigDecimal freezeAmount;

    /**
     * 已退款笔数
     */
    private Integer refundCount;

    /**
     *  已发放数量
     */
    private Integer issuedCount;

    /**
     *  已领取数量
     */
    private Integer receivedCount;

    /**
     * 冻结额度
     */
    private Integer freezeCount;


    // 流水参数

    /**
     * 流水类型
     */
    private AccountTradeRecordTypeEnum recordType;

    /**
     * 团队编号
     */
    private String refTeamCode;

    /**
     * 发放主体编号
     */
    private String refIssuingBodyCode;

    /**
     *  关联个人账户编号  冻结操作扣减团队/发放主体的时候有值
     */
    private String refPersonAcctNo;

    /**
     * 团队账户编号
     */
    private String refTeamAcctNo;

    /**
     * 发放主体账户编号
     */
    private String refIssuingBodyAcctNo;


    /**
     * 日志编号
     */
    private String logNo;


    /**
     * 额度扣减模式（个人账户才有）
     * @see SettlementConstant.DictDeductPattern
     */
    private String deductionPatten;


    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    // 更新后账户信息

    /**
     * 更新后账户信息
     */
    private AfterAmountDTO afterAmount;

    /**
     * 备注
     */
    private String remake;


}
