package com.rocogz.syy.settlement.dto;

import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * @author yinshihao
 * @date 2021/6/17
 */
@Data
public class UpdateAccountResDTO {

    /**
     * 发放主体编号
     */
    @NotBlank(message = "发放主体编号不能为空")
    private String issuingBodyCode;

    /**
     * 旧上级发放主体编号
     */
    @NotBlank(message = "旧上级发放主体编号不能为空")
    private String oldPIssuingBodyCode;

    /**
     * 上级发放主体编号
     */
    @NotBlank(message = "上级发放主体编号不能为空")
    private String pIssuingBodyCode;

    /**
     * 更新人
     */
    @NotNull(message = "更新人不能为空")
    private String updateUser;

    /**
     * 更新时间
     */
    @NotNull(message = "更新时间不能为空")
    private LocalDateTime updateTime;

    /**
     * 费用类型
     * @see SettlementConstant.FeeType
     */
    private String feeType;
}
