package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 添加开票事项作废dto
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterToVoidReqDto {

    /**
     * 编码
     */
    @NotBlank(message = "开票事项编号不能为空")
    private String code;

    /**
     * 开票事项前一个状态
     */
    @NotBlank(message = "开票事项前一个状态不能为空")
    private String preStatus;

    /**
     * 开票事项当前状态
     */
    @NotBlank(message = "开票事项当前状态不能为空")
    private String status;

    /**
     * 作废日期
     */
    @NotNull(message = "作废日期不能为空")
    private LocalDate toVoidTime;

    /**
     * 作废备注
     */
    @Length(max = 200, message = "作废备注长度不能超过200")
    private String toVoidRemark;

    /**
     * 作废附件列表
     */
    private List<InvoiceMatterAttachDto> matterAttchs;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
