package com.rocogz.syy.settlement.entity.attachment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 结算的通用附件
 * </p>
 *
 * @author huhailong
 * @since 2023-02-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettleAttachment extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 目标编码
     */
    private String targetCode;

    /**
     * 目标类型
     */
    private String targetType;

    /**
     * 目标排序号
     */
    private Integer targetSeq;

    /**
     * 上传的文件名
     */
    private String uploadName;

    /**
     * 自定义文件名
     */
    private String customName;

    /**
     * 文件路径
     */
    private String path;

    /**
     * 文件大小
     */
    private Integer fileSize;

    /**
     * 文件说明
     */
    private String description;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
