package com.rocogz.syy.settlement.entity.issuingbody.collection;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 发放主体收款记录的产品
 * </p>
 *
 * @author huhailong
 * @since 2023-04-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleIssuingBodyCollectionRecordProd extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款单号
     */
    private String collectionRecordCode;

    /**
     * 收款明细单号
     */
    private String collectionRecordItemCode;

    /**
     * 合作客户产品编号
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 平台产品类型
     */
    private String platformProductType;

    /**
     * 合作客户产品额度扣减单价
     */
    private BigDecimal customerProductSettlePrice;

    /**
     * 合作客户产品采购结算单价
     */
    private BigDecimal customerProductPurchaseSettlePrice;

    /**
     * 登记金额
     */
    private BigDecimal registrationAmount;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人 存储了中文名称
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人 存储了中文名称
     */
    private String updateUser;


    /**
     * 平台产品类型名称
     */
    @TableField(exist = false)
    private String platformProductTypeName;

}
