package com.rocogz.syy.settlement.entity.issuingbody.collection;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 发放主体收款记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleIssuingBodyCollectionRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款单号
     */
    private String code;

    /**
     * 服务商(代理商)编号
     */
    private String agentCode;

    /**
     * 结算主体编号
     */
    private String settleSubjectCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 收款金额
     */
    private BigDecimal collectionAmount;

    /**
     * 结算金额
     */
    private BigDecimal settledAmount;

    /**
     * 盈余金额
     */
    private BigDecimal surplusAmount;

    /**
     * 结算订单数量
     */
    private Integer settledOrderCount;

    /**
     * 收款日期
     */
    private LocalDate collectionDate;

    /**
     * 收款凭证
     */
    private String collectionVoucherImg;

    /**
     * 状态
     */
    private String status;

    /**
     * 收款备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


    /**
     * 代理商简称
     */
    @TableField(exist = false)
    private String agentAbbreviation;

    /**
     * 结算主体简称
     */
    @TableField(exist = false)
    private String settleSubjectAbbreviation;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    /**
     * 状态对应的名称
     */
    @TableField(exist = false)
    private String statusName;

}
