package com.rocogz.syy.settlement.enums.invoicematter;

/**
 * @Description: 服务商开票事项状态枚举类
 * @date：2021/9/8
 * @author：huangdeyi
 */
public enum AgentInvoiceMatterStatusEnum {

    /**
     * 草稿
     */
    DRAFT("DRAFT"),

    /**
     * 已开票
     */
    INVOICED("INVOICED"),

    /**
     * 已送达客户
     */
    DELIVERED("DELIVERED"),

    /**
     * 已收款
     */
    RECEIPTED("RECEIPTED"),

    /**
     * 发票已作废
     */
    VOIDED("VOIDED");

    private String status;

    AgentInvoiceMatterStatusEnum(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }
}
