package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户消息
 * </p>
 *
 * @author luoyingchang
 * @since 2020-06-11
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("user_msg")
public class UserMsg extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 发送者id
     */
    private Integer senderId;

    /**
     * 发送者名字
     */
    private String senderName;

    /**
     * 消息类型
     */
    private String msgType;

    /**
     * 消息标题
     */
    private String msgTitle;

    /**
     * 消息内容
     */
    private String msgContent;

    /**
     * 消息是否已读 0 未读 1 已读
     */
    private Integer hasRead;

    /**
     * 消息创建时间
     */
    private LocalDateTime createTime;

    /**
     * 消息阅读时间
     */
    private LocalDateTime readTime;

}
