package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;

/**
 * <p>
 * 二维码跳转参数配置
 * </p>
 *
 * @author liangyongtong
 * @since 2020-06-22
 */
@TableName("user_qr_parameter")
public class UserQrParameter extends IdEntity {

    private static final long serialVersionUID = 2746445858965067762L;
    /**
     * 编码，通过编码查找对应的路径
     */
    private String code;

    /**
     * 类型: H5:h5路径 MA:本小程序路径 OMA: 其它小程序路径
     */
    private String type;

    /**
     * 如果是OMA类型时对应的小程序appid
     */
    private String appid;

    /**
     * 对应的路径
     */
    private String url;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return "UserQrParameter{" +
        "code=" + code +
        ", type=" + type +
        ", appid=" + appid +
        ", url=" + url +
        "}";
    }
}
