package com.rocogz.syy.user.entity.identity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户中心-代理人身份认证
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-09-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("user_agent_identity_auth")
public class UserAgentIdentityAuth extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 用户openid
     */
    private String userWxOpenid;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 认证方式
     */
    private String authWay;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证号码
     */
    private String idCard;

    /**
     * 身份证号码后四位
     */
    private String idCardLastFourDigits;

    /**
     * 性别
     */
    private String idGender;

    /**
     * 身份证生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 身份证失效日期
     */
    private LocalDate expirationDate;

    /**
     * 身份证正面图片
     */
    private String frontImgPath;

    /**
     * 身份证反面图片
     */
    private String backImgPath;

    /**
     * 保险公司名称
     */
    private String companyName;

    /**
     * 资格证书号码
     */
    private String qualificationNumber;

    /**
     * 状态(待审核/审核通过/审核不通过)
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
