package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 推荐码管理
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-28
 */
@Data
@Accessors(chain = true)
@TableName("user_iiuv")
public class UserIiuv extends UserTimeEntity {


    private static final long serialVersionUID = 3777516957974052336L;
    /**
     * 推荐码
     */
    private String iiuvCode;

    /**
     * 推荐名称
     */
    private String iiuvName;

    /**
     * 推荐类型
     */
    private String iiuvType;

    /**
     * 推荐类型对应目标的编码
     */
    private String iiuvTargetCode;

    /**
     * 推荐码图片路径
     */
    private String iiuvUrl;

    /**
     * 二维码生成时间
     */
    private LocalDateTime generateTime;

    /**
     * 二维码是否生成
     */
    private String generate;

}
