package com.rocogz.syy.user.constant;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class UserConstant {
    private UserConstant(){}

    public static final String APPLICATION_NAME = "user-base-service";

    /**
     * 提现订单审核中心回调地址
     */
//    public static final String POPULARIZE_APPLY_APPROVEMENT_CALL_BACK_URL = "/api/order/withdrawals-record/approvementCallBack";
    public static final String POPULARIZE_APPLY_APPROVEMENT_CALL_BACK_URL = "/api/user/popularize/apply/approvementCallBack";

    /**
     * 微信用户性别字典typeCode
     */
    public static final String WX_USER_GENDER_TYPE_CODE = "WX_USER_GENDER";

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}
        public static final String CAR_OWNER_USER_STATUS_NORMAL_CODE = "NORMAL";
        public static final String CAR_OWNER_IDENTIFY_TYPE_OPENID_CODE = "OPENID";
        public static final String CAR_OWNER_IDENTIFY_TYPE_MOBILE_CODE = "MOBILE";

        /** 用户短信发送状态类型 */
        public static final String USER_MSG_SEND_STATUS_TYPE = "USER_MSG_SEND_STATUS_TYPE";
        /** 发送中 */
        public static final String SENDING = "SENDING";
        /** 调用成功 */
        public static final String SUCCESS_CALL = "SUCCESS_CALL";
        /** 调用失败 */
        public static final String FAIL_CALL = "FAIL_CALL";
        /** 发送成功 */
        public static final String SUCCESS = "SUCCESS";
        /** 发送失败 */
        public static final String FAIL = "FAIL";

        /** 消息模板类型 */
        public final static String USER_MSG_TYPE = "USER_MSG_TYPE";
        /** 普通消息 */
        public final static String NORMAL = "NORMAL";
        /** 短信消息 */
        public final static String SMS = "SMS";

        /** 短息消息执行类型 */
        public final static String USER_MSG_EXECUTE_TYPE = "USER_MSG_EXECUTE_TYPE";
        /** 立即执行 */
        public final static String NOW = "NOW";
        /** 定时执行 */
        public final static String TIMING = "TIMING";
        /** 证件类型编码-身份证 */
        public static final String CERTIFICATE_TYPE_ID_CODE = "01";

        /** 通用的是 */
        public static final String COMMON_YES = "Y";
        /** 通用的否 */
        public static final String COMMON_NO = "N";
        public static final String USER_IDENTITY_AGENT_CODE = "AGENT";
    }

    /**
     * 用户车辆信息
     */
    public static class CarInformation {
        private CarInformation(){}
        public static final String CAR_INFO_SOURCE_AUTO = "AUTO";//车辆信息来源-手动添加
        public static final String CAR_INFO_SOURCE_MANUAL = "MANUAL";//车辆信息来源-自动添加
        public static final String CAR_INFO_STATUS_NOT_CERTIFIED = "NOT_CERTIFIED";//车辆状态-未认证
    }

    /**
     * 收藏类型
     */
    public static class CollectionType {
        private CollectionType() {}
        /** 普通商户 */
        public static final String TYPE_STORE = "STORE";
        /** 油站 */
        public static final String TYPE_OIL = "OIL";
    }

    /**
     * 用户身份来源
     */
    public static class UserIdentitySource {
        private UserIdentitySource(){}
        public static final String TYPE_CODE = "USER_IDENTITY_SOURCE";
        public static final String CAR_OWNER = "CAR_OWNER";
    }

    /**
     * 用户身份状态
     */
    public static class UserIdentityStatus {
        private UserIdentityStatus(){}
        public static final String TYPE_CODE = "USER_IDENTITY_STATUS";
        public static final String NORMAL = "NORMAL";
        public static final String EXPIRATION = "EXPIRATION";
        public static final String LOCK = "LOCK";
    }

    /**
     * 用户代理人身份认证状态
     */
    public static class UserIdentityAuthStatus {
        private UserIdentityAuthStatus(){}
        public static final String TYPE_CODE = "USER_IDENTITY_AUTH_STATUS";
        /** 待审核 */
        public static final String PENDING_APPROVE = "PENDING_APPROVE";
        /** 审核不通过 */
        public static final String REFUSE = "REFUSE";
        /** 审核通过 */
        public static final String PASS = "PASS";
    }

    /**
     * 用户代理人身份认证方式
     */
    public static class UserIdentityAuthWay {
        private UserIdentityAuthWay(){}
        public static final String TYPE_CODE = "USER_IDENTITY_AUTH_WAY";
        /** 保险从业人员-资格证书 */
        public static final String QUALIFICATION = "QUALIFICATION";
        /** 保险从业人员-省份证尾号 */
        public static final String QUALIFICATION_ID_LAST = "QUALIFICATION_ID_LAST";
        /** 保险公司人员 */
        public static final String COMPANY = "COMPANY";
        /** 其他人员 */
        public static final String OTHER = "OTHER";
        /** 企业商户 */
        public static final String COMPANY_STORE = "COMPANY_STORE";
    }

    /**
     * 用户来源
     */
    public static class UserSource {
        private UserSource() {
        }

        public static final String TYPE_CODE = "USER_SOURCE";
        /**
         * 车主端
         */
        public static final String CAR_OWNER = "CAR_OWNER";
        /**
         * ROCO特惠商城
         */
        public static final String ROCO_MALL = "ROCO_MALL";
    }

    public static class UserAgentInviteNature {
        private UserAgentInviteNature() {}
        /** 注册 */
        public static final String REGISTER = "INVITE_REGISTER";
        /** 审核中 */
        public static final String AUDIT = "INVITE_AUDIT";
        /** 拒绝 */
        public static final String REFUSE = "INVITE_REFUSE";
        /** 认证 */
        public static final String IDENTIFICATION = "INVITE_IDENTIFICATION";
        /** 有效 */
        public static final String VALID = "INVITE_VALID";

        /** 待认证 */
        public static final String TO_BE_IDENTIFICATION = "TB_INVITE_IDENTIFICATION";
        /** 潜在用户 */
        public static final String TO_BE_VALID = "TB_INVITE_VALID";

    }

    /**
     * 用户代理人身份认证状态
     */
    public static class UserPopularizeApplyStatus {
        private UserPopularizeApplyStatus(){}
        /** 待审核 */
        public static final String PENDING_APPROVE = "PENDING_APPROVE";
        /** 审核不通过 */
        public static final String REFUSE = "REFUSE";
        /** 审核通过 */
        public static final String PASS = "PASS";
    }

    /**
     * 用户状态
     */
    public static class UserStatus {
        private UserStatus(){}
        public static final String TYPE_CODE = "CAR_OWNER_USER_STATUS";
        /** 正常 */
        public static final String NORMAL = "NORMAL";
        /** 锁定 */
        public static final String LOCK = "LOCK";
        /** 注销 */
        public static final String CANCEL = "CANCEL";
    }

    /**
     * 手机绑定状态
     */
    public static class MobileBindStatus {
        //已绑定
        public static final String BIND = "BIND";
        //未绑定
        public static final String UNBIND = "UNBIND";
    }

    /**
     * 推荐码扫码记录-类型
     */
    public static class QrCodeScanningType {
        private QrCodeScanningType(){}
        /** 字典列表编码 */
        public static final String TYPE_CODE = "QR_CODE_SCANNING_TYPE";
        /** 扫码 */
        public static final String QR_CODE = "QR_CODE";
        /** 分享 */
        public static final String SHARE = "SHARE";
    }
}
