package com.rocogz.syy.user.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class UserMsgWebDto {

    /**
     * 用户code
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 微信昵称
     */
    @ApiModelProperty("微信昵称")
    private String wxNickName;

    /**
     * 绑定手机号
     */
    @ApiModelProperty("手机号")
    private String bindMobile;

    /**
     * 消息code 相当于唯一主键
     */
    @ApiModelProperty("消息编号")
    private String code;

    /**
     * 消息类型
     */
    @ApiModelProperty("消息类型")
    private String msgType;

    /**
     * 消息标题
     */
    @ApiModelProperty("消息标题")
    private String msgTitle;

    /**
     * 消息内容
     */
    @ApiModelProperty("消息内容")
    private String msgContent;

    /**
     * 消息是否已读 0 未读 1 已读
     */
    @ApiModelProperty("是否已读")
    private Integer hasRead;

    /**
     * 消息阅读时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("阅读时间")
    private LocalDateTime readTime;

    /**
     * 消息是否删除 0 未删除 1 已删除
     */
    @ApiModelProperty("是否删除")
    private Integer delStatus;

    /**
     * 发送者code
     */
    @ApiModelProperty("发送者编号")
    private String senderCode;

    /**
     * 发送者名字
     */
    @ApiModelProperty("发送者名字")
    private String senderName;

    /**
     * 消息创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 发送来源编码
     */
    private String sendSourceCode;

    /**
     * 模板编码
     */
    private String templateCode;

    /**
     * 短信编码
     */
    private String smsCode;

    /**
     * 父业务单号
     * 2021-03-24新增，用于记录[批量发券的业务单号]
     */
    private String parentBizCode;

    /**
     * 业务单号
     */
    private String bizCode;

    /**
     * 短信参数
     */
    private String params;

    /**
     * 发送状态
     */
    private String sendStatus;

    /**
     * 错误信息
     */
    private String msgErrorInfo;

    /**
     * 重发次数
     */
    private Integer retryNum;

    /**
     * 短信执行发送类型
     */
    private String executeType;

    /**
     * 定时执行时间
     */
    private LocalDateTime executeTime;

}
