package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户中心-登录凭证
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-09
 */
@TableName("user_login_credentials")
@ApiModel("用户登录凭证")
@Data
@EqualsAndHashCode(callSuper = false)
public class UserLoginCredentials extends IdEntity {

    private static final long serialVersionUID = 8655514679867627831L;
    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 用户来源(CAR_OWNER:车主端;ROCO_MALL:ROCO特惠商城)
     */
    @ApiModelProperty("用户来源(CAR_OWNER:车主端;ROCO_MALL:ROCO特惠商城)")
    private String source;

    /**
     * 账号类型(OPENID/MOBILE)
     */
    @ApiModelProperty("账号类型(OPENID/MOBILE)")
    private String type;

    /**
     * 登录凭证(OPENID值/手机号)
     */
    @ApiModelProperty("登录凭证(OPENID值/手机号)")
    private String credentials;
}
