package com.rocogz.syy.user.entity.certificate;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户证件信息
 * </p>
 *
 * @author yinshihao
 * @since 2020-05-15
 */
@ApiModel("用户证件信息")
@Data
@TableName("user_certificate_info")
public class UserCertificateInfo extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 证件类型
     */
    @ApiModelProperty("证件类型")
    private String certificateType;

    /**
     * 证件号码
     */
    @ApiModelProperty(value = "证件号码", required = true)
    private String certificateNumber;

    /**
     * 用户姓名
     */
    @ApiModelProperty(value = "用户姓名", required = true)
    private String name;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String gender;

    /**
     * 正面图片地址
     */
    @ApiModelProperty(value = "正面图片地址")
    private String frontImgPath;

    /**
     * 背面图片地址
     */
    @ApiModelProperty(value = "背面图片地址")
    private String backImgPath;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期", required = true)
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    private LocalDate beginEffective;

    /**
     * 失效日期
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty(value = "失效日期", required = true)
    private LocalDate endEffective;

    /**
     * 创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;
}
