package com.rocogz.syy.user.entity.certificate;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户行驶证
 * </p>
 *
 * @author yinshihao
 * @since 2020-05-15
 */
@ApiModel("用户行驶证信息")
@Data
@TableName("user_drivering_licence_info")
public class UserDriveringLicenceInfo extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户编号
     */
    @ApiModelProperty("用户编号")
    private String userCode;

    /**
     * 用户姓名
     */
    @ApiModelProperty(value = "用户姓名", required = true)
    private String name;

    /**
     * 车牌号
     */
    @ApiModelProperty(value = "车牌号", required = true)
    private String carNumber;

    /**
     * 车辆类型
     */
    @ApiModelProperty(value = "车辆类型", required = true)
    private String carType;

    /**
     * 车辆识别代号
     */
    @ApiModelProperty(value = "车辆识别代号", required = true)
    private String carIdentifiyNumber;

    /**
     * 发动机代号
     */
    @ApiModelProperty(value = "发动机代号", required = true)
    private String engineNumber;

    /**
     * 正面图片地址
     */
    @ApiModelProperty(value = "正面图片地址", required = true)
    private String frontImgPath;

    /**
     * 背面图片地址
     */
    @ApiModelProperty(value = "背面图片地址", required = true)
    private String backImgPath;

    /**
     * 注册日期
     */
    @ApiModelProperty(value = "注册日期", required = true)
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    private LocalDate registerDate;

    /**
     * 发证日期
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty(value = "发证日期", required = true)
    private LocalDate issueDate;

    /**
     * 创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;
}
