package com.rocogz.syy.user.entity.identity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 用户手机绑定操作记录entity
 * @date：2021/9/26
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("user_mobile_bind_operation_record")
public class UserMobileBindOperationRecord extends IdEntity {

    private static final long serialVersionUID = 606605360517899729L;

    /**
    * 用户code
    */
    private String userCode;
    
    /**
    * 操作类型：BIND-绑定、UNBIND-解绑
    */
    private String operationType;
    
    /**
    * 微信昵称
    */
    private String wxNickName;
    
    /**
    * 微信openid
    */
    private String wxOpenid;
    
    /**
    * 解绑/绑定手机号
    */
    private String mobile;
    
    /**
    * 操作时间
    */
    private LocalDateTime operationTime;
    
    /**
    * 操作人姓名
    */
    private String operatorName;
    
    /**
    * 操作人手机号
    */
    private String operatorMobile;
}