package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户消息
 * </p>
 *
 * @author luoyingchang
 * @since 2020-06-11
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("user_msg")
public class UserMsg extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 发送来源编码
     */
    private String sendSourceCode;

    /**
     * 消息模板编码
     */
    private String templateCode;

    /**
     * 短信编码
     */
    private String smsCode;

    /**
     * 用户code
     */
    private String userCode;

    /**
     * 发送者code
     */
    private String senderCode;

    /**
     * 发送者名字
     */
    private String senderName;

    /**
     * 消息类型
     */
    private String msgType;

    /**
     * 消息标题
     */
    private String msgTitle;

    /**
     * 消息内容
     */
    private String msgContent;

    /**
     * 消息是否已读 0 未读 1 已读
     */
    private Integer hasRead;

    /**
     * 消息code 相当于唯一主键
     */
    private String code;

    /**
     * 消息创建时间
     */
    private LocalDateTime createTime;

    /**
     * 消息阅读时间
     */
    private LocalDateTime readTime;

    /**
     * 消息是否删除 0 未删除 1 已删除
     */
    private Integer delStatus;

    @TableField(exist = false)
    private String paramsMap;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 业务单号
     */
    private String bizCode;

    /**
     * 阿里云短信id
     */
    private String bizId;

    /**
     * 短信参数
     */
    private String params;

    /**
     * 发送状态
     */
    private String sendStatus;

    /**
     * 错误信息
     */
    private String msgErrorInfo;

    /**
     * 重发次数
     */
    private Integer retryNum;

}
