package com.rocogz.syy.user.dto.issuingbody;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * The type User issuing body customer search dto.
 * @author huangdeyi
 */
@Data
@Accessors(chain = true)
public class UserIssuingBodyCustomerSearchDto {

    /**
     * 客户编号
     */
    private String code;

    /**
     * 客户手机号
     */
    private String mobile;

    /**
     * 用户微信openid
     */
    private String userWxOpenid;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 主体编号，以逗号分割
     */
    private String issuingBodyCode;

    /**
     * 小程序id，以逗号分割
     */
    private String miniAppid;

    /**
     * 当前页数
     */
    private Integer page;

    /**
     * 每页记录数
     */
    private Integer limit;

    /**
     * 是否导出
     */
    private Boolean export = false;
}
