/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;

public class DateUtil {
    public static final String YYYY_MM = "yyyyMM";
    public static final String YYYY__MM = "yyyy-MM";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String DATE_KEY_STR = "yyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String DEFAULT_DATE = "2099-12-31";
    public static final String START_TIME = " 00:00:00";
    public static final String END_TIME = " 23:59:59";

    public static Date parseToDateTime(String strDate) {
        return DateUtil.parse(strDate, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date parseToDate(String strDate) {
        return DateUtil.parse(strDate, YYYY_MM_DD);
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int compareDateWithNow(Date date) {
        return DateUtil.compareDate(date, new Date());
    }

    public static int compareDate(Date date1, Date date2) {
        int rnum = date1.compareTo(date2);
        return rnum;
    }

    public static long format(String date) {
        long timestamp = 0L;
        try {
            timestamp = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static long format(String date, String pattern) {
        long timestamp = 0L;
        try {
            timestamp = new SimpleDateFormat(pattern).parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static String format(Date date, String pattern) {
        String timestamp = "0";
        try {
            timestamp = new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static String format(LocalDate date, String pattern) {
        String timestamp = "0";
        try {
            timestamp = DateTimeFormatter.ofPattern(pattern).format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static long dateToUnixTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp;
    }

    public static String formatDate(String dateStr, String formatStr) {
        return new SimpleDateFormat(formatStr).format(DateUtil.parseToDate(dateStr));
    }

    public static LocalDateTime formatDateStrToLocalDateTime(String dateStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        return LocalDateTime.parse(dateStr, df);
    }

    public static String formatLocalDateTimeToString(LocalDateTime localDateTime) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        return df.format(localDateTime);
    }

    public static int getWeekCntByDate(String date) {
        return DateUtil.getWeekCntByDate(LocalDate.parse(date));
    }

    public static int getWeekCntByDate(LocalDate localDate) {
        String dateStr = localDate.format(DateTimeFormatter.ofPattern(YYYY_MM_DD));
        int currentDay = localDate.getDayOfMonth();
        int days = localDate.withMonth(localDate.getMonth().getValue()).lengthOfMonth();
        String firstDate = dateStr.substring(0, 7) + "-01";
        LocalDate firstLocalDate = LocalDate.parse(firstDate);
        int firstDayWeek = firstLocalDate.getDayOfWeek().getValue();
        String endDate = dateStr.substring(0, 7) + "-" + days;
        LocalDate endLocalDate = LocalDate.parse(endDate);
        int endDayWeek = endLocalDate.getDayOfWeek().getValue();
        int weekCnt = (days - (7 - firstDayWeek + 1) - endDayWeek) / 7 + 2;
        HashMap<Integer, Integer> weekDayMap = new HashMap<Integer, Integer>();
        weekDayMap.put(1, 7 - firstDayWeek + 1);
        for (int i = 2; i < weekCnt; ++i) {
            weekDayMap.put(i, 7 - firstDayWeek + 1 + (i - 1) * 7);
        }
        weekDayMap.put(weekCnt, days);
        for (Integer week : weekDayMap.keySet()) {
            int weekDayRange = (Integer)weekDayMap.get(week);
            if (currentDay > weekDayRange) continue;
            return week;
        }
        return -1;
    }

    public static String getWeekNumIdByDate(LocalDate localDate) {
        String dateStr = localDate.format(DateTimeFormatter.ofPattern(YYYY_MM));
        return dateStr + "0" + String.valueOf(DateUtil.getWeekCntByDate(localDate));
    }

    public static Date localDateToDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean dateValidate(String startDate, String endDate) {
        Integer startInt = DateUtil.compareDate(DateUtil.localDateToDate(LocalDate.now()), DateUtil.parseToDate(startDate));
        Integer endInt = DateUtil.compareDate(DateUtil.localDateToDate(LocalDate.now()), DateUtil.parseToDate(endDate));
        return startInt != -1 && (endInt == -1 || endInt == 0);
    }

    public static int dateStatus(String startDate, String endDate) {
        Integer startInt = DateUtil.compareDate(DateUtil.localDateToDate(LocalDate.now()), DateUtil.parseToDate(startDate));
        Integer endInt = DateUtil.compareDate(DateUtil.localDateToDate(LocalDate.now()), DateUtil.parseToDate(endDate));
        if (startInt == -1 && endInt == -1) {
            return 0;
        }
        if (startInt != -1 && (endInt == -1 || endInt == 0)) {
            return 1;
        }
        return 2;
    }

    public static LocalDate formatLocalDateByPattern(String date, String pattern) {
        if (date == null) {
            return null;
        }
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(pattern));
    }
}

