package com.rocogz.syy.weixin.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.List;

/**
 * 微信小程序配置信息
 * @author：liangyongtong
 * @since：2020/5/12
 */
@Data
@ConfigurationProperties(prefix = "wx.miniapp")
public class WeixinConfigProperties {
    /** 消息数据格式 */
    private String msgDataFormat;
    /** 应用程序id */
    protected String appid;
    /** secret */
    private String secret;
    /** token */
    protected String token;
    /** 会话token */
    private String accessToken;
    /** aes键 */
    private String aesKey;
    /** 过期时间 */
    private long expiresTime;

    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    /** 缓存位置，默认本地 */
    private CacheLocation location = CacheLocation.local;

    /** Redis缓存前缀 */
    private String cachePrefix = "wxSessionToken";

    /**
     * accessToken 缓存位置
     */
    enum CacheLocation {
        /** 使用本地缓存 */
        local,
        /** 使用 redis缓存 */
        redis
    }

    /**
     * 支持多个小程序配置
     */
    private List<WeixinConfigProperties> configs;
}
