/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.weixin.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.rocogz.redis.RedisService;
import com.rocogz.syy.weixin.config.WeixinConfigProperties;
import com.rocogz.syy.weixin.config.WxMaRedisConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={WeixinConfigProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix="wx.miniapp", name={"wxKey"}, matchIfMissing=true)
public class WeixinAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(WeixinAutoConfig.class);
    @Autowired
    private WeixinConfigProperties props;
    @Autowired
    private RedisService redisService;

    @Bean
    public WxMaService wxMaService() {
        log.info("\u914d\u7f6e\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u5f00\u59cb");
        WxMaServiceImpl maService = new WxMaServiceImpl();
        if (WeixinConfigProperties.CacheLocation.redis.name().equals(this.props.getLocation().name())) {
            WxMaRedisConfig wxMaRedisConfig = new WxMaRedisConfig(this.redisService);
            wxMaRedisConfig.setRedisKeyPrefix(this.props.getCachePrefix());
            wxMaRedisConfig.setMaId(this.props.getAppid());
            this.setConfiguration(wxMaRedisConfig);
            maService.setWxMaConfig((WxMaConfig)wxMaRedisConfig);
        } else {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            this.setConfiguration(config);
            maService.setWxMaConfig((WxMaConfig)config);
        }
        log.info("\u914d\u7f6e\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u7ed3\u675f");
        return maService;
    }

    private void setConfiguration(WxMaDefaultConfigImpl configImpl) {
        configImpl.setMsgDataFormat(this.props.getMsgDataFormat());
        configImpl.setAppid(this.props.getAppid());
        configImpl.setSecret(this.props.getSecret());
        configImpl.setToken(this.props.getToken());
        configImpl.setAccessToken(this.props.getAccessToken());
        configImpl.setAesKey(this.props.getAesKey());
        configImpl.setExpiresTime(this.props.getExpiresTime());
        configImpl.setHttpProxyHost(this.props.getHttpProxyHost());
        configImpl.setHttpProxyPort(this.props.getHttpProxyPort());
        configImpl.setHttpProxyUsername(this.props.getHttpProxyUsername());
        configImpl.setHttpProxyPassword(this.props.getHttpProxyPassword());
    }
}

