/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.weixin.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.rocogz.redis.RedisService;
import com.rocogz.syy.weixin.config.MultiWxMaService;
import com.rocogz.syy.weixin.config.WeixinConfigProperties;
import com.rocogz.syy.weixin.config.WxMaRedisConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={WeixinConfigProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix="wx.miniapp", name={"wxKey"}, matchIfMissing=true)
public class WeixinAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(WeixinAutoConfig.class);
    @Autowired
    private WeixinConfigProperties props;
    @Autowired
    private RedisService redisService;

    @Bean
    public WxMaService wxMaService() {
        WxMaServiceImpl maService = null;
        if (null != this.props.getAppid() && !"".equals(this.props.getAppid())) {
            log.info("\u914d\u7f6e\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u5f00\u59cb");
            maService = this.getWxMaService(this.props);
            log.info("\u914d\u7f6e\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u7ed3\u675f");
        }
        return maService;
    }

    private WxMaServiceImpl getWxMaService(WeixinConfigProperties prop) {
        WxMaServiceImpl maService = new WxMaServiceImpl();
        if (WeixinConfigProperties.CacheLocation.redis.name().equals(prop.getLocation().name())) {
            WxMaRedisConfig wxMaRedisConfig = new WxMaRedisConfig(this.redisService);
            wxMaRedisConfig.setRedisKeyPrefix(prop.getCachePrefix());
            wxMaRedisConfig.setMaId(prop.getAppid());
            this.setConfiguration(wxMaRedisConfig, prop);
            maService.setWxMaConfig((WxMaConfig)wxMaRedisConfig);
        } else {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            this.setConfiguration(config, prop);
            maService.setWxMaConfig((WxMaConfig)config);
        }
        return maService;
    }

    @Bean
    public MultiWxMaService multiWxMaService() {
        MultiWxMaService multiWxMaService = new MultiWxMaService();
        if (null != this.props.getConfigs() && this.props.getConfigs().size() > 0) {
            log.info("\u914d\u7f6e\u5fae\u4fe1\u591a\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u5f00\u59cb");
            this.props.getConfigs().forEach(p -> multiWxMaService.addWxService(p.getAppid(), (WxMaService)this.getWxMaService((WeixinConfigProperties)p)));
            log.info("\u914d\u7f6e\u5fae\u4fe1\u591a\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u7ed3\u675f");
        }
        return multiWxMaService;
    }

    private void setConfiguration(WxMaDefaultConfigImpl configImpl, WeixinConfigProperties prop) {
        configImpl.setMsgDataFormat(prop.getMsgDataFormat());
        configImpl.setAppid(prop.getAppid());
        configImpl.setSecret(prop.getSecret());
        configImpl.setToken(prop.getToken());
        configImpl.setAccessToken(prop.getAccessToken());
        configImpl.setAesKey(prop.getAesKey());
        configImpl.setExpiresTime(prop.getExpiresTime());
        configImpl.setHttpProxyHost(prop.getHttpProxyHost());
        configImpl.setHttpProxyPort(prop.getHttpProxyPort());
        configImpl.setHttpProxyUsername(prop.getHttpProxyUsername());
        configImpl.setHttpProxyPassword(prop.getHttpProxyPassword());
    }
}

