package com.rocogz.syy.weixin.config;


import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.rocogz.redis.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 配置小程序服务对象
 * @author：liangyongtong
 * @since：2020/5/12
 */
@Slf4j
@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(WeixinConfigProperties.class)
@AutoConfigureAfter(WebMvcAutoConfiguration.class)
@ConditionalOnProperty(prefix = "wx.miniapp", name = "wxKey", matchIfMissing = true)
public class WeixinAutoConfig {

    @Autowired
    private WeixinConfigProperties props;

    @Autowired
    private RedisService redisService;

    @Bean
    public WxMaService wxMaService() {

        WxMaServiceImpl maService = null;
        if (null != props.getAppid() && !"".equals(props.getAppid())) {
            log.info("配置微信小程序信息开始");
            maService = getWxMaService(this.props);
            log.info("配置微信小程序信息结束");
        }
        return maService;
    }

    /**
     * 获取小程序服务对象
     * @param prop
     * @return
     */
    private WxMaServiceImpl getWxMaService(WeixinConfigProperties prop) {
        WxMaServiceImpl maService = new WxMaServiceImpl();


        // redis
        if (WeixinConfigProperties.CacheLocation.redis.name().equals(prop.getLocation().name())) {
            WxMaRedisConfig wxMaRedisConfig = new WxMaRedisConfig(redisService);

            wxMaRedisConfig.setRedisKeyPrefix(prop.getCachePrefix());
            wxMaRedisConfig.setMaId(prop.getAppid());

            setConfiguration(wxMaRedisConfig, prop);
            maService.setWxMaConfig(wxMaRedisConfig);
        }
        // 本地
        else {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();

            setConfiguration(config, prop);
            maService.setWxMaConfig(config);
        }
        return maService;
    }

    @Bean
    public MultiWxMaService multiWxMaService() {
        MultiWxMaService multiWxMaService = new MultiWxMaService();

        if (null != props.getConfigs() && props.getConfigs().size() > 0) {
            log.info("配置微信多小程序信息开始");
            this.props.getConfigs().forEach(p -> {
                multiWxMaService.addWxService(p.getAppid(), getWxMaService(p));
            });
            log.info("配置微信多小程序信息结束");
        }

        return multiWxMaService;
    }

    /**
     * 设置配置
     * @param configImpl
     */
    private void setConfiguration(WxMaDefaultConfigImpl configImpl, WeixinConfigProperties prop) {
        configImpl.setMsgDataFormat(prop.getMsgDataFormat());
        configImpl.setAppid(prop.getAppid());
        configImpl.setSecret(prop.getSecret());
        configImpl.setToken(prop.getToken());
        configImpl.setAccessToken(prop.getAccessToken());
        configImpl.setAesKey(prop.getAesKey());
        configImpl.setExpiresTime(prop.getExpiresTime());
        configImpl.setHttpProxyHost(prop.getHttpProxyHost());
        configImpl.setHttpProxyPort(prop.getHttpProxyPort());
        configImpl.setHttpProxyUsername(prop.getHttpProxyUsername());
        configImpl.setHttpProxyPassword(prop.getHttpProxyPassword());
    }
}
