/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.weixin.config;

import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.rocogz.redis.RedisDistributedLock;
import com.rocogz.redis.RedisService;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;

public class WxMaRedisConfig
extends WxMaDefaultConfigImpl {
    private RedisService redisService;
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String JSAPI_TICKET = "jsapiTicket";
    private static final String CARD_API_TICKET = "cardApiTicket";
    private static final String HASH_VALUE_FIELD = "value";
    private static final String HASH_EXPIRE_FIELD = "expire";
    private String redisKeyPrefix = "maConfig";
    private String maId;
    private Lock accessTokenLock;
    private Lock jsapiTicketLock;
    private Lock cardApiTicketLock;

    public WxMaRedisConfig(RedisService redisService) {
        this.redisService = redisService;
    }

    private String getRedisKey(String key) {
        StringBuilder redisKey = new StringBuilder(this.redisKeyPrefix).append(":");
        if (this.maId == null) {
            return redisKey.append(key).toString();
        }
        return redisKey.append(this.maId).append(":").append(key).toString();
    }

    private String getValueFromRedis(String key) {
        return this.redisService.hget(this.getRedisKey(key), HASH_VALUE_FIELD);
    }

    private void setValueToRedis(String key, long expiresTime, String value) {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put(HASH_VALUE_FIELD, value);
        hash.put(HASH_EXPIRE_FIELD, String.valueOf(expiresTime));
        this.redisService.hsetAll(this.getRedisKey(key), hash);
    }

    private long getExpireFromRedis(String key) {
        String expire = this.redisService.hget(this.getRedisKey(key), HASH_EXPIRE_FIELD);
        return expire == null ? 0L : Long.parseLong(expire);
    }

    private void setExpire(String key, long expiresTime) {
        this.redisService.hset(this.getRedisKey(key), HASH_EXPIRE_FIELD, String.valueOf(expiresTime));
    }

    public void setRedisKeyPrefix(String redisKeyPrefix) {
        this.redisKeyPrefix = redisKeyPrefix;
    }

    public void setMaId(String maId) {
        this.maId = maId;
    }

    public String getAccessToken() {
        return this.getValueFromRedis(ACCESS_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getAccessTokenLock() {
        if (this.accessTokenLock == null) {
            WxMaRedisConfig wxMaRedisConfig = this;
            synchronized (wxMaRedisConfig) {
                if (this.accessTokenLock == null) {
                    this.accessTokenLock = new RedisDistributedLock(this.getRedisKey("accessTokenLock"), this.redisService);
                }
            }
        }
        return this.accessTokenLock;
    }

    public boolean isAccessTokenExpired() {
        return this.isExpired(this.getExpireFromRedis(ACCESS_TOKEN));
    }

    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.setValueToRedis(ACCESS_TOKEN, this.expiresAheadInMillis(expiresInSeconds), accessToken);
    }

    public String getJsapiTicket() {
        return this.getValueFromRedis(JSAPI_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getJsapiTicketLock() {
        if (this.jsapiTicketLock == null) {
            WxMaRedisConfig wxMaRedisConfig = this;
            synchronized (wxMaRedisConfig) {
                if (this.jsapiTicketLock == null) {
                    this.jsapiTicketLock = new RedisDistributedLock(this.getRedisKey("jsapiTicketLock"), this.redisService);
                }
            }
        }
        return this.jsapiTicketLock;
    }

    public boolean isJsapiTicketExpired() {
        return this.isExpired(this.getExpireFromRedis(JSAPI_TICKET));
    }

    public void expireJsapiTicket() {
        this.setExpire(JSAPI_TICKET, 0L);
    }

    public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.setValueToRedis(JSAPI_TICKET, this.expiresAheadInMillis(expiresInSeconds), jsapiTicket);
    }

    public String getCardApiTicket() {
        return this.getValueFromRedis(CARD_API_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getCardApiTicketLock() {
        if (this.cardApiTicketLock == null) {
            WxMaRedisConfig wxMaRedisConfig = this;
            synchronized (wxMaRedisConfig) {
                if (this.cardApiTicketLock == null) {
                    this.cardApiTicketLock = new RedisDistributedLock(this.getRedisKey("cardApiTicketLock"), this.redisService);
                }
            }
        }
        return this.cardApiTicketLock;
    }

    public boolean isCardApiTicketExpired() {
        return this.isExpired(this.getExpireFromRedis(CARD_API_TICKET));
    }

    public void expireCardApiTicket() {
        this.setExpire(CARD_API_TICKET, 0L);
    }

    public void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.setValueToRedis(CARD_API_TICKET, this.expiresAheadInMillis(expiresInSeconds), cardApiTicket);
    }

    public void expireAccessToken() {
        this.setExpiresTime(0L);
    }

    public long getExpiresTime() {
        return this.getExpireFromRedis(ACCESS_TOKEN);
    }

    public void setExpiresTime(long expiresTime) {
        this.setExpire(ACCESS_TOKEN, expiresTime);
    }
}

