package com.rocogz.syy.weixin.config;

import cn.binarywang.wx.miniapp.api.WxMaService;

import java.util.HashMap;
import java.util.Map;

/**
 * 支持多小程序配置
 * @author：liangyongtong
 * @since：2020/9/11
 */
public class MultiWxMaService {
    private Map<String, WxMaService> multiWxService = new HashMap<>();

    /**
     * 获取小程序操作服务
     * @param appid
     * @return
     */
    public WxMaService instantiation(String appid) {
        return this.multiWxService.get(appid);
    }

    /**
     * 设置小程序服务
     * @param appid
     * @param service
     */
    public void addWxService(String appid, WxMaService service) {
        this.multiWxService.put(appid, service);
    }

    /**
     * 返回有几个小程序服务
     * @return
     */
    public int size() {
        return this.multiWxService.size();
    }
}
