/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.weixin.pay.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.rocogz.syy.weixin.pay.config.WxPayProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WxPayProperties.class})
@ConditionalOnClass(value={WxPayService.class})
@ConditionalOnProperty(prefix="wx.pay", value={"enabled"}, matchIfMissing=true)
public class WxPayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxPayAutoConfiguration.class);
    private WxPayProperties properties;

    @Autowired
    public WxPayAutoConfiguration(WxPayProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={WxPayService.class})
    public WxPayService wxPayService() {
        log.info("\u521d\u59cb\u5316\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u5f00\u59cb");
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getMchKey()));
        payConfig.setSubAppId(StringUtils.trimToNull((String)this.properties.getSubAppId()));
        payConfig.setSubMchId(StringUtils.trimToNull((String)this.properties.getSubMchId()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getKeyPath()));
        payConfig.setTradeType(StringUtils.trimToNull((String)this.properties.getTradeType()));
        payConfig.setNotifyUrl(StringUtils.trimToNull((String)this.properties.getNotifyUrl()));
        payConfig.setUseSandboxEnv(this.properties.isUseSandboxEnv());
        wxPayService.setConfig(payConfig);
        log.info("\u521d\u59cb\u5316\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u7ed3\u675f");
        return wxPayService;
    }
}

