/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.weixin.pay.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.rocogz.syy.weixin.pay.config.WxPayProperties;
import com.rocogz.syy.weixin.pay.config.WxPayServiceHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WxPayProperties.class})
@ConditionalOnClass(value={WxPayServiceHolder.class})
@ConditionalOnProperty(prefix="wx.pay", value={"enabled"}, matchIfMissing=true)
public class WxPayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxPayAutoConfiguration.class);
    @Autowired
    private WxPayProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={WxPayServiceHolder.class})
    public WxPayServiceHolder wxPayService() {
        log.info("\u521d\u59cb\u5316\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u5f00\u59cb");
        WxPayServiceHolder holder = new WxPayServiceHolder();
        for (WxPayProperties.Config config : this.properties.getConfigList()) {
            WxPayConfig payConfig = new WxPayConfig();
            payConfig.setAppId(StringUtils.trimToNull((String)config.getAppId()));
            payConfig.setMchId(StringUtils.trimToNull((String)config.getMchId()));
            payConfig.setMchKey(StringUtils.trimToNull((String)config.getMchKey()));
            payConfig.setSubAppId(StringUtils.trimToNull((String)config.getSubAppId()));
            payConfig.setSubMchId(StringUtils.trimToNull((String)config.getSubMchId()));
            payConfig.setKeyPath(StringUtils.trimToNull((String)config.getKeyPath()));
            payConfig.setTradeType(StringUtils.trimToNull((String)config.getTradeType()));
            payConfig.setNotifyUrl(StringUtils.trimToNull((String)config.getNotifyUrl()));
            payConfig.setUseSandboxEnv(config.isUseSandboxEnv());
            holder.getWxPayConfigMap().put(config.getMchId(), payConfig);
            if (Boolean.TRUE.equals(config.isDefaultMch())) {
                holder.setDefaultMch(payConfig);
            }
            if (StringUtils.isEmpty((CharSequence)payConfig.getAppId())) continue;
            WxPayServiceImpl wxPayService = new WxPayServiceImpl();
            wxPayService.setConfig(payConfig);
            holder.getWxPayServiceMap().put(config.getMchId() + "_" + config.getAppId(), (WxPayService)wxPayService);
            holder.getDefaultRefundNotifyUrlMap().put(config.getMchId(), config.getRefundNotifyUrl());
        }
        log.info("\u521d\u59cb\u5316\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u7ed3\u675f");
        return holder;
    }
}

