/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.aop.logger;

import com.rocoinfo.aop.logger.Logger;
import com.rocoinfo.aop.logger.entity.LoggerEntity;
import com.rocoinfo.aop.logger.entity.Principal;
import com.rocoinfo.aop.logger.principal.PrincipalHandler;
import com.rocoinfo.aop.logger.utils.LoggerJsonUtils;
import com.rocoinfo.aop.logger.utils.ServerUtils;
import eu.bitwalker.useragentutils.UserAgent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LoggerAspect {
    @Autowired(required=false)
    private PrincipalHandler principalHandler;
    @Value(value="${aspect.logger.app.name:}")
    private String app;
    @Value(value="${aspect.logger.name:com.rocoinfo.api}")
    private String loggerName;
    private org.slf4j.Logger slf4jLogger;
    private static final String DEFALUT_LOGGER_NAME = "com.rocoinfo.api";

    @PostConstruct
    public void init() {
        if (this.loggerName == null || "".equals(this.loggerName.trim())) {
            this.loggerName = DEFALUT_LOGGER_NAME;
        }
        this.slf4jLogger = LoggerFactory.getLogger((String)this.loggerName);
    }

    @Pointcut(value="within(com.rocoinfo..*) && @annotation(com.rocoinfo.aop.logger.Logger)")
    public void logger() {
    }

    @Around(value="logger()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        Long startTime = System.currentTimeMillis();
        LoggerEntity loggerEntity = this.buildLoggerEntity(jp);
        Object result = null;
        boolean success = true;
        try {
            result = jp.proceed();
        }
        catch (Throwable e) {
            loggerEntity.setSuccess(Boolean.FALSE).setMessage(e.getMessage());
            success = false;
            throw e;
        }
        finally {
            Long endTime = System.currentTimeMillis();
            loggerEntity.setExecTime(endTime - startTime);
            if (!success) {
                this.slf4jLogger.error(LoggerJsonUtils.toJson(loggerEntity));
            }
        }
        loggerEntity.setSuccess(Boolean.TRUE).setResult(result);
        this.slf4jLogger.info(LoggerJsonUtils.toJson(loggerEntity));
        return result;
    }

    private Object[] excludeType(Object[] args) {
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof ServletRequest || arg instanceof ServletResponse) continue;
                argsList.add(arg);
            }
        }
        return argsList.toArray();
    }

    private LoggerEntity buildLoggerEntity(ProceedingJoinPoint jp) {
        Object[] args = this.excludeType(jp.getArgs());
        MethodSignature signature = (MethodSignature)jp.getSignature();
        String[] paramNames = signature.getParameterNames();
        Method method = signature.getMethod();
        Logger logger = method.getAnnotation(Logger.class);
        Class<?> clazz = method.getDeclaringClass();
        String methodSignature = clazz.getName() + "." + method.getName();
        String ip = this.getIp();
        String url = this.getRequestUrl();
        String username = this.getUsername();
        String requestMethod = this.getRequestMethod();
        String browserType = this.getBrowser();
        Map<String, Object> params = this.builderParams(paramNames, args);
        LoggerEntity loggerEntity = new LoggerEntity().setValue(logger.value()).setApp(this.app).setModule(logger.module()).setIp(ip).setUrl(url).setDate(new Date()).setRequestMethod(requestMethod).setMethodSignature(methodSignature).setParams(params).setUsername(username).setBrowserType(browserType).setServerIp(ServerUtils.getServerIp());
        return loggerEntity;
    }

    private Map<String, Object> builderParams(String[] paramNames, Object[] args) {
        if (paramNames != null && args != null && paramNames.length > 0 && args.length > 0) {
            int size = paramNames.length > args.length ? args.length : paramNames.length;
            HashMap<String, Object> params = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                params.put(paramNames[i], args[i]);
            }
            return params;
        }
        return new HashMap<String, Object>();
    }

    private HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    private String getIp() {
        HttpServletRequest request = this.getHttpServletRequest();
        return request.getRemoteAddr();
    }

    private String getRequestUrl() {
        HttpServletRequest request = this.getHttpServletRequest();
        return request.getRequestURI();
    }

    private String getRequestMethod() {
        HttpServletRequest request = this.getHttpServletRequest();
        return request.getMethod();
    }

    private String getBrowser() {
        HttpServletRequest request = this.getHttpServletRequest();
        UserAgent userAgent = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        return userAgent.getBrowser().toString();
    }

    private String getUsername() {
        if (this.principalHandler != null) {
            Principal principal = this.principalHandler.getPrincipal();
            return principal == null ? "" : principal.getUsername();
        }
        return "";
    }
}

