package com.rocoinfo.aop.logger;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <dl>
 * <dd>Description: 需要记录日志的方法上加注解，指定日志所属的模块</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/5/17 下午2:33</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Logger {

    /**
     * value的值为一个附加字段，打印的日志会带上value的值
     *
     * @return
     */
    String value() default "";

    /**
     * 标识该日志所属的模块
     *
     * @return
     */
    String module() default "default";

    /**
     * 排除的参数，不想被记录的参数（如密码等），可以将参数名配置到此数组中
     *
     * @return
     */
    String[] excludeParams() default {};

}