package com.rocoinfo.aop.logger.entity;

import com.rocoinfo.aop.logger.LoggerType;

import java.io.Serializable;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/6/8 上午10:30</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class LoggerEntity implements Serializable {

    /**
     * 日志类型
     */
    private LoggerType type;

    /**
     * 注解上带的value的值
     */
    private String value;

    /**
     * app
     */
    private String app;

    /**
     * 请求模块
     */
    private String module;

    /**
     * 请求的ip
     */
    private String ip;

    /**
     * 服务器ip
     */
    private String server;

    /**
     * 请求的url
     */
    private String url;

    /**
     * 调用时间
     */
    private Long timestamp;

    /**
     * 请求方式
     */
    private String method;

    /**
     * 方法签名
     */
    private String signature;

    /**
     * 请求参数
     */
    private Map<String, Object> params;

    /**
     * 当前登录的用户名
     */
    private String username;

    /**
     * 浏览器类型
     */
    private String browser;

    /**
     * 是否成功
     */
    private Boolean success;

    /**
     * 错误信息
     */
    private String error;

    /**
     * 错误日志跟踪信息
     */
    private String trace;


    /**
     * 返回结果
     */
    private Object result;

    /**
     * 执行时间
     */
    private long resptime;

    public LoggerType getType() {
        return type;
    }

    public LoggerEntity setType(LoggerType type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return value;
    }

    public LoggerEntity setValue(String value) {
        this.value = value;
        return this;
    }

    public String getApp() {
        return app;
    }

    public LoggerEntity setApp(String app) {
        this.app = app;
        return this;
    }

    public String getModule() {
        return module;
    }

    public LoggerEntity setModule(String module) {
        this.module = module;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public LoggerEntity setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getServer() {
        return server;
    }

    public LoggerEntity setServer(String server) {
        this.server = server;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public LoggerEntity setUrl(String url) {
        this.url = url;
        return this;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public LoggerEntity setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getMethod() {
        return method;
    }

    public LoggerEntity setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getSignature() {
        return signature;
    }

    public LoggerEntity setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public LoggerEntity setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public LoggerEntity setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getBrowser() {
        return browser;
    }

    public LoggerEntity setBrowser(String browser) {
        this.browser = browser;
        return this;
    }

    public Boolean getSuccess() {
        return success;
    }

    public LoggerEntity setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public String getError() {
        return error;
    }

    public LoggerEntity setError(String error) {
        this.error = error;
        return this;
    }

    public Object getResult() {
        return result;
    }

    public LoggerEntity setResult(Object result) {
        this.result = result;
        return this;
    }

    public long getResptime() {
        return resptime;
    }

    public LoggerEntity setResptime(long resptime) {
        this.resptime = resptime;
        return this;
    }

    public String getTrace() {
        return trace;
    }

    public LoggerEntity setTrace(String trace) {
        this.trace = trace;
        return this;
    }
}
