package com.rocoinfo.aop.logger.utils;

import eu.bitwalker.useragentutils.UserAgent;

import javax.servlet.http.HttpServletRequest;

/**
 * <dl>
 * <dd>Description: http相关工具类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/7/17 上午10:08</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public final class HttpUtils {

    private HttpUtils() {
    }

    /**
     * 获取请求方的ip
     *
     * @param req request
     * @return
     */
    public static String getRequestIp(HttpServletRequest req) {
        return req.getRemoteAddr();
    }

    /**
     * 获取请求的url
     *
     * @param req request
     * @return
     */
    public static String getRequestUrl(HttpServletRequest req) {
        return req.getRequestURI();
    }

    /**
     * 获取请求的方式 GET、POST、DELETE
     *
     * @param req request
     * @return
     */
    public static String getRequestMethod(HttpServletRequest req) {
        return req.getMethod();
    }

    /**
     * 获取请求方的浏览器类型
     *
     * @param req request
     * @return
     */
    public static String getRequestBrowser(HttpServletRequest req) {
        UserAgent userAgent = UserAgent.parseUserAgentString(req.getHeader("User-Agent"));
        return userAgent.getBrowser().toString();
    }
}
