/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.ContextAware;
import com.rocoinfo.appender.FlumeAvroMaster;
import com.rocoinfo.appender.FlumeHost;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.event.EventBuilder;

public class FlumeAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private FlumeAvroMaster master;
    private Boolean power;
    private String hosts;
    private Integer batchSize;
    private Long maxIdleTime;
    private Integer eventQueueSize;
    private Map<String, String> additionHeaders;
    private String additionProps;
    private Integer maxThreadPoolSize;
    private Integer workQueueSize;
    private Layout<ILoggingEvent> layout;

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public void setPower(String power) {
        this.power = Boolean.valueOf(power);
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setAdditionProps(String additionProps) {
        this.additionProps = additionProps;
    }

    public void setAdditionHeaders(String additionHeaders) {
        this.additionHeaders = this.extractProperties(additionHeaders);
    }

    public void setBatchSize(String batchSizeStr) {
        try {
            this.batchSize = Integer.parseInt(batchSizeStr);
        }
        catch (NumberFormatException nfe) {
            this.addWarn("Cannot set the batchSize to " + batchSizeStr, nfe);
        }
    }

    public void setMaxIdleTime(String maxIdleTime) {
        try {
            this.maxIdleTime = Long.parseLong(maxIdleTime);
        }
        catch (NumberFormatException nfe) {
            this.addWarn("\u89e3\u6790maxIdleTime\u53c2\u6570\u5931\u8d25: " + maxIdleTime, nfe);
        }
    }

    public void setMaxThreadPoolSize(String maxThreadPoolSize) {
        try {
            this.maxThreadPoolSize = Integer.parseInt(maxThreadPoolSize);
        }
        catch (NumberFormatException nfe) {
            this.addWarn("\u89e3\u6790maxThreadPoolSize\u53c2\u6570\u5931\u8d25: " + maxThreadPoolSize, nfe);
        }
    }

    public void setEventQueueSize(String eventQueueSize) {
        try {
            this.eventQueueSize = Integer.parseInt(eventQueueSize);
        }
        catch (NumberFormatException nfe) {
            this.addWarn("\u89e3\u6790eventQueueSize\u53c2\u6570\u5931\u8d25: " + this.maxThreadPoolSize, nfe);
        }
    }

    public void setWorkQueueSize(String workQueueSize) {
        try {
            this.workQueueSize = Integer.parseInt(workQueueSize);
        }
        catch (NumberFormatException nfe) {
            this.addWarn("\u89e3\u6790workQueueSize\u53c2\u6570\u5931\u8d25: " + this.maxThreadPoolSize, nfe);
        }
    }

    public void start() {
        if (this.layout == null) {
            this.addWarn("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6eappender\uff0c\u5c06\u9ed8\u8ba4\u8f93\u51fa\u539f\u751f\u7684message");
        }
        if (!this.isPowerOn()) {
            return;
        }
        List<FlumeHost> flumeHosts = this.extractFlumeHosts();
        if (CollectionUtils.isNotEmpty(flumeHosts)) {
            Properties props = new Properties();
            props.putAll(this.extractProperties(this.additionProps));
            this.master = FlumeAvroMaster.create(flumeHosts, props, this.batchSize, this.eventQueueSize, this.maxIdleTime, this.maxThreadPoolSize, this.workQueueSize, (ContextAware)this);
        } else {
            this.addError("\u9519\u8bef\u7684flume agent host");
        }
        super.start();
    }

    private List<FlumeHost> extractFlumeHosts() {
        if (StringUtils.isNotEmpty((String)this.hosts)) {
            String[] hostSegments = this.replaceBlank(this.hosts).split(",");
            ArrayList<FlumeHost> hosts = new ArrayList<FlumeHost>(hostSegments.length);
            for (String segment : hostSegments) {
                FlumeHost host = FlumeHost.fromString(segment.trim());
                if (host != null) {
                    hosts.add(host);
                    continue;
                }
                this.addWarn("\u9519\u8bef\u7684flume agent host\uff1a" + host);
            }
            return hosts;
        }
        return null;
    }

    private Map<String, String> extractProperties(String s) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)s)) {
            String[] segments;
            for (String segment : segments = this.replaceBlank(s).split(",")) {
                String[] pair = segment.split("=");
                if (pair.length != 2) continue;
                String key = StringUtils.strip((String)pair[0]);
                String value = StringUtils.strip((String)pair[1]);
                if (StringUtils.isNotEmpty((String)key) && StringUtils.isNotEmpty((String)value)) {
                    props.put(key.trim(), value.trim());
                    continue;
                }
                this.addWarn("\u5c5e\u6027\u7684key\u6216value\u4e0d\u80fd\u4e3a\u7a7a: " + segment);
            }
        }
        return props;
    }

    public void stop() {
        try {
            if (this.master != null) {
                this.master.stop();
            }
        }
        catch (FlumeException fe) {
            this.addWarn(fe.getMessage(), fe);
        }
    }

    protected void append(ILoggingEvent e) {
        if (this.master != null && this.isPowerOn()) {
            try {
                String body = this.layout != null ? this.layout.doLayout((Object)e) : e.getFormattedMessage();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("level", e.getLevel().levelStr);
                if (MapUtils.isNotEmpty(this.additionHeaders)) {
                    headers.putAll(this.additionHeaders);
                }
                Event event = EventBuilder.withBody((String)StringUtils.strip((String)body), (Charset)UTF_8, headers);
                this.master.commit(event);
            }
            catch (Exception ex) {
                this.addError(ex.getLocalizedMessage(), ex);
            }
        }
    }

    private String replaceBlank(String s) {
        if (StringUtils.isNotBlank((String)s)) {
            return Pattern.compile("\\s*|\t|\r|\n").matcher(s).replaceAll("");
        }
        return "";
    }

    private boolean isPowerOn() {
        return this.power;
    }
}

