/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.appender;

import ch.qos.logback.core.spi.ContextAware;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Event;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeAvroWorker {
    private RpcClient client;
    private final ContextAware loggingContext;
    private final ExecutorService es;
    private final Properties connectionProps;

    public FlumeAvroWorker(Properties properties, ContextAware context, int maximumThreadPoolSize, int workQueueSize) {
        ArrayBlockingQueue<Runnable> blockingQueue = new ArrayBlockingQueue<Runnable>(workQueueSize);
        this.connectionProps = properties;
        this.loggingContext = context;
        int corePoolSize = 1;
        TimeUnit threadKeepAliveUnits = TimeUnit.SECONDS;
        int threadKeepAliveTime = 30;
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        this.es = new ThreadPoolExecutor(corePoolSize, maximumThreadPoolSize, (long)threadKeepAliveTime, threadKeepAliveUnits, blockingQueue, handler);
    }

    public void send(Event[] events) {
        this.es.submit(new WorkTask(events));
    }

    private synchronized RpcClient createClient() {
        if (this.client == null) {
            this.loggingContext.addInfo("\u5f00\u59cb\u521b\u5efaRpcClient\uff0c\u914d\u7f6e\u4fe1\u606f\uff1a: " + this.connectionProps);
            try {
                this.client = RpcClientFactory.getInstance((Properties)this.connectionProps);
            }
            catch (Exception e) {
                this.loggingContext.addError(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.client;
    }

    public synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void shutdown() {
        this.close();
        this.es.shutdown();
    }

    private class WorkTask
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private static final int RETRIES = 3;
        private final Event[] events;

        public WorkTask(Event[] events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            int count = 0;
            try {
                while (!success && count < 3) {
                    ++count;
                    try {
                        FlumeAvroWorker.this.createClient().appendBatch(Arrays.asList(this.events));
                        success = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.warn(e.getLocalizedMessage(), (Throwable)e);
                        this.logger.warn("\u53d1\u9001\u5931\u8d25\uff0c\u5f00\u59cb\u7b2c" + (3 - count) + "\u6b21\u91cd\u8bd5");
                    }
                }
            }
            finally {
                if (!success) {
                    this.logger.error("\u4e8b\u4ef6\u53d1\u9001\u5931\u8d25\uff01");
                    FlumeAvroWorker.this.close();
                }
            }
        }
    }
}

