/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.appender;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlumeHost {
    private static final Logger logger = LoggerFactory.getLogger(FlumeHost.class);
    private final String hostname;
    private final int port;

    public FlumeHost(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public static FlumeHost fromString(String input) {
        if (StringUtils.isNotEmpty((String)input)) {
            String[] parts = input.split(":");
            if (parts.length == 2) {
                String portString = parts[1].trim();
                try {
                    int port = Integer.parseInt(portString.trim());
                    return new FlumeHost(parts[0], port);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Not a valid int: " + portString);
                }
            } else {
                logger.error("Not a valid [host]:[port] configuration: " + input);
            }
        } else {
            logger.error("Empty flume agent entry, an extra comma?");
        }
        return null;
    }
}

