/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.api.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtil {
    public static final String YYYY_MM = "yyyyMM";
    public static final String YYYY__MM = "yyyy-MM";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String DATE_KEY_STR = "yyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String START_TIME = " 00:00:00";
    public static final String END_TIME = " 23:59:59";

    public static Date parseToDateTime(String strDate) {
        return DateUtil.parse(strDate, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date parseToDate(String strDate) {
        return DateUtil.parse(strDate, YYYY_MM_DD);
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int compareDateWithNow(Date date) {
        return DateUtil.compareDate(date, new Date());
    }

    public static int compareDate(Date date1, Date date2) {
        int rnum = date1.compareTo(date2);
        return rnum;
    }

    public static long format(String date) {
        return DateUtil.format(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static long format(String date, String pattern) {
        long timestamp = 0L;
        try {
            timestamp = new SimpleDateFormat(pattern).parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static String format(Date date, String pattern) {
        String timestamp = "0";
        try {
            timestamp = new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static long dateToUnixTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp;
    }

    public static String formatDate(String dateStr, String formatStr) {
        return new SimpleDateFormat(formatStr).format(DateUtil.parseToDate(dateStr));
    }

    public static LocalDateTime formatDateStrToLocalDateTime(String dateStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        return LocalDateTime.parse(dateStr, df);
    }

    public static LocalDate parseToLocalDate(String s) {
        if (s == null) {
            return null;
        }
        return LocalDate.parse(s, DateTimeFormatter.ofPattern(YYYY_MM_DD));
    }

    public static String getProbablyTimeCN(Integer seconds) {
        StringBuilder result = new StringBuilder();
        try {
            if (seconds == null && seconds < 0) {
                return null;
            }
            int h = seconds / 3600;
            int m = seconds % 3600 / 60;
            int s = seconds % 3600 % 60;
            if (h > 0) {
                result.append(h).append("\u5c0f\u65f6");
            }
            if (m > 0) {
                result.append(m).append("\u5206\u949f");
            }
            if (h == 0 && m == 0 && s > 0) {
                result.append(s).append("\u79d2");
            }
            return result.toString();
        }
        catch (Exception e) {
            return result.toString();
        }
    }
}

