/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceDayStatistic;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceDayStatisticReq;
import com.rocoinfo.oilcard.batch.api.response.common.InvoiceAmountStatisticResp;
import com.rocoinfo.oilcard.batch.base.utils.MapUtils;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceDayStatisticDao;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEventHandler;
import com.rocoinfo.oilcard.batch.utils.StatisticUtils;
import java.time.LocalDate;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class InvoiceDayAmountStatisticHandler
extends BaseSingleTemplate<InvoiceDayStatisticReq, InvoiceAmountStatisticResp> {
    @Resource
    private InvoiceDayStatisticDao invoiceDayStatisticDao;
    @Resource
    private InvoiceEventHandler invoiceEventHandler;

    protected InvoiceAmountStatisticResp callInner(CommonRequest<InvoiceDayStatisticReq> commonRequest) throws Exception {
        InvoiceDayStatisticReq req = (InvoiceDayStatisticReq)commonRequest.getRequest();
        String endDate = req.getEndDate();
        Boolean isContainCurrentDay = StatisticUtils.checkIsContainCurrentDate((InvoiceDayStatisticReq)req);
        if (isContainCurrentDay.booleanValue()) {
            endDate = LocalDate.now().minusDays(1L).toString();
        }
        HashMap params = new HashMap();
        MapUtils.putNotNull(params, (String)"startDay", (Object)req.getStartDate());
        MapUtils.putNotNull(params, (String)"endDay", (Object)endDate);
        MapUtils.putNotNull(params, (String)"invoiceNature", (Object)req.getInvoiceNature());
        InvoiceAmountStatisticResp amount = this.invoiceDayStatisticDao.getAmount(params);
        if (isContainCurrentDay.booleanValue()) {
            InvoiceDayStatistic statistic = this.invoiceEventHandler.getDayRealTimeStatistic(req.getInvoiceNature(), LocalDate.now());
            if (amount != null && statistic != null) {
                amount.setInvalidCnt(Integer.valueOf(amount.getInvalidCnt() + statistic.getInvalidCnt()));
                amount.setTotalCnt(Integer.valueOf(amount.getTotalCnt() + statistic.getTotalCnt()));
                amount.setInvalidTaxAmount(amount.getInvalidTaxAmount().add(statistic.getInvalidAmount()));
                amount.setTotalTaxAmount(amount.getTotalTaxAmount().add(statistic.getTotalTaxAmount()));
            } else if (amount == null && statistic != null) {
                InvoiceAmountStatisticResp statisticResp = new InvoiceAmountStatisticResp();
                statisticResp.setInvalidCnt(statistic.getInvalidCnt());
                statisticResp.setTotalCnt(statistic.getTotalCnt());
                statisticResp.setInvalidTaxAmount(statistic.getInvalidAmount());
                statisticResp.setTotalTaxAmount(statistic.getTotalTaxAmount());
                return statisticResp;
            }
        }
        return amount;
    }
}

