/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.template.BaseQueryPageTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceDayStatistic;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceDayStatisticReq;
import com.rocoinfo.oilcard.batch.base.utils.MapUtils;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceDayStatisticDao;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEventHandler;
import com.rocoinfo.oilcard.batch.utils.StatisticUtils;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class InvoiceDayStatisticHandler
extends BaseQueryPageTemplate<InvoiceDayStatisticReq, InvoiceDayStatistic> {
    @Resource
    private InvoiceDayStatisticDao invoiceDayStatisticDao;
    @Resource
    private InvoiceEventHandler invoiceEventHandler;

    protected List<InvoiceDayStatistic> callInner(CommonQueryPageRequest<InvoiceDayStatisticReq> commonQueryPageRequest) throws Exception {
        InvoiceDayStatisticReq req = (InvoiceDayStatisticReq)commonQueryPageRequest.getRequest();
        String endDate = req.getEndDate();
        Boolean isContainCurrentDay = StatisticUtils.checkIsContainCurrentDate((InvoiceDayStatisticReq)req);
        if (isContainCurrentDay.booleanValue()) {
            endDate = LocalDate.now().minusDays(1L).toString();
        }
        HashMap params = new HashMap();
        MapUtils.putNotNull(params, (String)"startDay", (Object)req.getStartDate());
        MapUtils.putNotNull(params, (String)"endDay", (Object)endDate);
        MapUtils.putNotNull(params, (String)"invoiceNature", (Object)req.getInvoiceNature());
        List list = this.invoiceDayStatisticDao.search(params);
        if (isContainCurrentDay.booleanValue()) {
            InvoiceDayStatistic statistic = this.invoiceEventHandler.getDayRealTimeStatistic(req.getInvoiceNature(), LocalDate.now());
            list.add(0, statistic);
        }
        return list;
    }
}

