/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.common.CommonJobParam;
import com.rocoinfo.oilcard.batch.base.job.StartBatchJob;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class InvoiceJobStatisticStartHandler
extends BaseSingleTemplate<InvoiceJobReq, Boolean> {
    @Autowired
    private Job cleanInvoiceJob;
    @Autowired
    private Job invoiceStatisticDayJob;
    @Autowired
    private Job invoiceStatisticMonthJob;
    @Autowired
    private Job invoiceStatisticTranstionJob;
    @Autowired
    private CommonJobParam commonJobParam;
    @Autowired
    private ThreadPoolTaskExecutor batchTaskExecutor;

    protected Boolean callInner(CommonRequest<InvoiceJobReq> request) throws Exception {
        Map jobMap = this.commonJobParam.jobNameList(new Job[]{this.cleanInvoiceJob, this.invoiceStatisticTranstionJob, this.invoiceStatisticDayJob, this.invoiceStatisticMonthJob});
        InvoiceJobReq invoiceJobReq = (InvoiceJobReq)request.getRequest();
        JobParameters jobParameters = new JobParametersBuilder().addString("startDate", invoiceJobReq.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addString("endDate", invoiceJobReq.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addLong("timeStamp", Long.valueOf(System.currentTimeMillis())).toJobParameters();
        this.batchTaskExecutor.execute((Runnable)new StartBatchJob(this.commonJobParam.getJobLauncher(), jobMap, jobParameters));
        return true;
    }
}

