/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.job.StepExecutionStatus;
import com.rocoinfo.oilcard.batch.api.request.common.JobNodesReq;
import com.rocoinfo.oilcard.batch.base.common.CommonJobParam;
import com.rocoinfo.oilcard.batch.base.job.StartBatchJob;
import com.rocoinfo.oilcard.batch.dao.batch.StepExecutionStatusDao;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class InvoiceSingleStartHandler
extends BaseSingleTemplate<JobNodesReq, Boolean> {
    @Autowired
    private Job cleanInvoiceJob;
    @Autowired
    private Job invoiceStatisticDayJob;
    @Autowired
    private Job invoiceStatisticMonthJob;
    @Autowired
    private Job invoiceStatisticTranstionJob;
    @Autowired
    private CommonJobParam commonJobParam;
    @Autowired
    private StepExecutionStatusDao stepExecutionStatusDao;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;

    protected Boolean callInner(CommonRequest<JobNodesReq> request) throws Exception {
        this.startSingleJob((JobNodesReq)request.getRequest());
        return true;
    }

    public void startSingleJob(JobNodesReq jobNodesReq) throws Exception {
        JobParameters jobParameters = new JobParametersBuilder().addString("startDate", jobNodesReq.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addString("endDate", jobNodesReq.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addLong("id", jobNodesReq.getId()).addLong("timeStamp", Long.valueOf(System.currentTimeMillis())).toJobParameters();
        StepExecutionStatus stepExecutionStatus = this.stepExecutionStatusDao.getByPkId(jobNodesReq.getId());
        this.batchTaskExecutor.execute((Runnable)new StartBatchJob(this.commonJobParam.getJobLauncher(), this.getNextJob(stepExecutionStatus.getStepName()), jobParameters));
    }

    private Map<Integer, Job> getNextJob(String currentJob) throws Exception {
        switch (currentJob) {
            case "cleanInvoiceJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.cleanInvoiceJob, this.invoiceStatisticTranstionJob, this.invoiceStatisticDayJob, this.invoiceStatisticMonthJob});
            }
            case "invoiceStatisticTranstionJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceStatisticTranstionJob, this.invoiceStatisticDayJob, this.invoiceStatisticMonthJob});
            }
            case "invoiceStatisticDayJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceStatisticDayJob, this.invoiceStatisticMonthJob});
            }
            case "invoiceStatisticMonthJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceStatisticMonthJob});
            }
        }
        return null;
    }
}

