/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceStatistic;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceApplyStatusEnum;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceStatisticDao;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsMqPushReq;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.assertj.core.util.Throwables;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class InvoiceStatisticHandler
extends BaseSingleTemplate<InvoiceStatisticsMqPushReq, Boolean> {
    @Resource
    private InvoiceStatisticDao invoiceStatisticDao;

    protected Boolean callInner(CommonRequest<InvoiceStatisticsMqPushReq> commonRequest) throws Exception {
        InvoiceStatisticsMqPushReq reqData = (InvoiceStatisticsMqPushReq)commonRequest.getRequest();
        InvoiceStatistic invoiceStatistic = this.invoiceStatisticDao.getByInvoiceNature(reqData.getInvoiceNature());
        int count = 0;
        if (invoiceStatistic == null && InvoiceApplyStatusEnum.CONFIRMED.name().equals(reqData.getStatus())) {
            InvoiceStatistic invoiceStatistics = new InvoiceStatistic();
            invoiceStatistics.setCreateTime(LocalDateTime.now());
            invoiceStatistics.setTotalAmount(reqData.getInvoiceAccount());
            invoiceStatistics.setTotalTaxAmount(reqData.getTaxAccount());
            invoiceStatistics.setTotalCnt(Integer.valueOf(1));
            invoiceStatistics.setInvalidCnt(Integer.valueOf(0));
            invoiceStatistics.setInvalidTaxAmount(BigDecimal.ZERO);
            invoiceStatistics.setInvoiceNature(InvoiceNatureEnum.valueOf((String)reqData.getInvoiceNature()));
            count = this.invoiceStatisticDao.insert(invoiceStatistics);
        } else if (invoiceStatistic == null && InvoiceApplyStatusEnum.INVALID.name().equals(reqData.getStatus())) {
            InvoiceStatistic invoiceStatistics = new InvoiceStatistic();
            invoiceStatistics.setCreateTime(LocalDateTime.now());
            invoiceStatistics.setTotalAmount(BigDecimal.ZERO);
            invoiceStatistics.setTotalTaxAmount(BigDecimal.ZERO);
            invoiceStatistics.setTotalCnt(Integer.valueOf(0));
            invoiceStatistics.setInvalidCnt(Integer.valueOf(1));
            invoiceStatistics.setInvalidTaxAmount(reqData.getTaxAccount());
            invoiceStatistics.setInvoiceNature(InvoiceNatureEnum.valueOf((String)reqData.getInvoiceNature()));
        } else if (invoiceStatistic != null && InvoiceApplyStatusEnum.CONFIRMED.name().equals(reqData.getStatus())) {
            InvoiceStatisticsDTO invoiceStatisticsDTO = new InvoiceStatisticsDTO();
            invoiceStatisticsDTO.setInvoiceAmount(reqData.getInvoiceAccount());
            invoiceStatisticsDTO.setInvoiceTaxAmount(reqData.getTaxAccount());
            invoiceStatisticsDTO.setUpdateTime(LocalDateTime.now());
            invoiceStatisticsDTO.setInvoiceNature(InvoiceNatureEnum.valueOf((String)reqData.getInvoiceNature()));
            count = this.invoiceStatisticDao.addTotalAmount(invoiceStatisticsDTO);
        } else if (invoiceStatistic != null && InvoiceApplyStatusEnum.INVALID.name().equals(reqData.getStatus())) {
            InvoiceStatisticsDTO invoiceStatisticsDTO = new InvoiceStatisticsDTO();
            invoiceStatisticsDTO.setInvoiceAmount(reqData.getInvoiceAccount());
            invoiceStatisticsDTO.setInvoiceTaxAmount(reqData.getTaxAccount());
            invoiceStatisticsDTO.setUpdateTime(LocalDateTime.now());
            invoiceStatisticsDTO.setInvoiceNature(InvoiceNatureEnum.valueOf((String)reqData.getInvoiceNature()));
            count = this.invoiceStatisticDao.addInvalidAmount(invoiceStatisticsDTO);
        }
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u7edf\u8ba1\u6570\u636e\u5931\u8d25");
        return true;
    }

    public String getErrorMsg(Throwable e) {
        String errMsg = Throwables.getStackTrace((Throwable)e);
        if (errMsg.length() > 2048) {
            errMsg = errMsg.substring(0, 2048);
        }
        return errMsg;
    }
}

