/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.consumer;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import com.rabbitmq.client.Channel;
import com.rocogz.common.api.request.CommonRequest;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.api.enums.MqCustomerStatus;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsMqPushReq;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEventHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceStatisticHandler;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvoiceStatisticsConsumer {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatisticsConsumer.class);
    @Autowired
    private InvoiceEventHandler invoiceEventService;
    @Autowired
    private InvoiceStatisticHandler invoiceStatisticsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"invoice_statistics_queue"})
    public void onMessage(Channel channel, Message message) throws Exception {
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        String messageBody = new String(message.getBody(), Charsets.UTF_8);
        InvoiceStatisticsMqPushReq invoiceStatisticsMqPushReq = (InvoiceStatisticsMqPushReq)JSON.parseObject((String)messageBody, InvoiceStatisticsMqPushReq.class);
        InvoiceEvent invoiceEvent = new InvoiceEvent();
        InvoiceEvent oldInvoiceEvent = this.invoiceEventService.search(invoiceStatisticsMqPushReq.getApplyCode(), invoiceStatisticsMqPushReq.getStatus());
        if (oldInvoiceEvent != null) {
            if (MqCustomerStatus.SUCCESS.equals((Object)oldInvoiceEvent.getResult())) {
                return;
            }
            invoiceEvent.setId(oldInvoiceEvent.getId());
            invoiceEvent.setUpdateTime(LocalDateTime.now());
        } else {
            BeanUtils.copyProperties((Object)invoiceStatisticsMqPushReq, (Object)invoiceEvent);
            invoiceEvent.setResult(MqCustomerStatus.INIT);
            invoiceEvent.setCreateTime(LocalDateTime.now());
            invoiceEvent.setUpdateTime(LocalDateTime.now());
            invoiceEvent.setInvoiceNature(InvoiceNatureEnum.valueOf((String)invoiceStatisticsMqPushReq.getInvoiceNature()));
            invoiceEvent.setConfirmInvoiceDate(invoiceEvent.getConfirmInvoiceTime().toLocalDate());
        }
        log.info("\u5f00\u7968\u7edf\u8ba1MQ\u6d88\u8d39\u5f00\u59cb,\u53d1\u7968\u7533\u8bf7\u5355\u53f7:{}", (Object)invoiceStatisticsMqPushReq.getApplyCode());
        this.invoiceEventService.callService(new CommonRequest(), invoiceEvent);
        try {
            this.invoiceStatisticsService.callService(new CommonRequest(), invoiceStatisticsMqPushReq);
            invoiceEvent.setResult(MqCustomerStatus.SUCCESS);
        }
        catch (Throwable e) {
            log.error("\u6d88\u8d39MQ\u5bf9\u516c\u8ba2\u5355\u5f02\u5e38", e);
            invoiceEvent.setResult(MqCustomerStatus.FAIL);
            invoiceEvent.setResultMsg(this.invoiceStatisticsService.getErrorMsg(e));
        }
        finally {
            invoiceEvent.setUpdateTime(LocalDateTime.now());
            this.invoiceEventService.callService(new CommonRequest(), invoiceEvent);
            channel.basicAck(deliveryTag, false);
            log.info("\u5f00\u7968\u7edf\u8ba1MQ\u6d88\u8d39\u5b8c\u6210,\u53d1\u7968\u7533\u8bf7\u5355\u53f7:{}", (Object)invoiceStatisticsMqPushReq.getApplyCode());
        }
    }
}

