/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.batch;

import com.rocogz.common.exception.BizException;
import com.rocoinfo.oilcard.batch.api.entity.job.BatchJobInstance;
import com.rocoinfo.oilcard.batch.api.entity.job.StepExecutionStatus;
import com.rocoinfo.oilcard.batch.api.request.common.JobNodesReq;
import com.rocoinfo.oilcard.batch.dao.batch.StepExecutionStatusDao;
import java.util.List;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StepExecutionStatusHandler {
    @Autowired
    private StepExecutionStatusDao stepExecutionStatusDao;
    @Autowired
    private JobOperator jobOperator;

    public List<StepExecutionStatus> findStepStatus(String businessType) {
        return this.stepExecutionStatusDao.findStepStatus(businessType);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStepStatus(String stepName, Long jobExecutionId, String status) {
        this.stepExecutionStatusDao.updateStepStatus(stepName, jobExecutionId, status);
    }

    public int updateStepStatusToInit(String stepName) {
        return this.stepExecutionStatusDao.updateStepStatusToInit(stepName);
    }

    public boolean stopSingleJob(JobNodesReq jobNodesReq) throws Exception {
        try {
            StepExecutionStatus stepExecutionStatus = this.stepExecutionStatusDao.getByPkId(jobNodesReq.getId());
            boolean stopFlag = this.jobOperator.stop(stepExecutionStatus.getJobExecutionId().longValue());
            if (stopFlag) {
                BatchJobInstance batchJobInstance = this.stepExecutionStatusDao.getStepInfoByJobExecutionId(stepExecutionStatus.getJobExecutionId());
                this.updateStepStatus(batchJobInstance.getJobName(), null, "STOP");
            }
        }
        catch (Exception e) {
            if (e instanceof JobExecutionNotRunningException) {
                throw new BizException("\u4efb\u52a1\u672a\u542f\u52a8\u4e0d\u80fd\u505c\u6b62", (Object)e.getMessage());
            }
            throw e;
        }
        return true;
    }
}

