/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceDayStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceMonthStatistic;
import com.rocoinfo.oilcard.batch.api.enums.MqCustomerStatus;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEventDao;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceEventHandler
extends BaseSingleTemplate<InvoiceEvent, InvoiceEvent> {
    private static final String CONFIRMED = "CONFIRMED";
    private static final String INVALID = "INVALID";
    @Resource
    private InvoiceEventDao invoiceEventDao;

    protected InvoiceEvent callInner(CommonRequest<InvoiceEvent> request) throws Exception {
        InvoiceEvent invoiceEvent = (InvoiceEvent)request.getRequest();
        if (null == invoiceEvent.getId()) {
            this.invoiceEventDao.insert(invoiceEvent);
        } else {
            this.invoiceEventDao.update(invoiceEvent);
        }
        return invoiceEvent;
    }

    public InvoiceEvent search(String applyCode, String status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("applyCode", applyCode);
        params.put("status", status);
        return this.invoiceEventDao.search(params);
    }

    public InvoiceDayStatistic getDayRealTimeStatistic(String invoiceNature, LocalDate localDate) {
        InvoiceDayStatistic invoiceDayStatistic = new InvoiceDayStatistic();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statisticDay", localDate);
        map.put("invoiceNature", invoiceNature);
        map.put("result", MqCustomerStatus.SUCCESS.name());
        List<InvoiceEvent> invoiceEvents = this.invoiceEventDao.realTimeDateStatistic(map);
        if (CollectionUtils.isEmpty(invoiceEvents)) {
            invoiceDayStatistic.setStatisticDay(localDate.toString());
            invoiceDayStatistic.setTotalTaxAmount(BigDecimal.ZERO);
            invoiceDayStatistic.setInvalidAmount(BigDecimal.ZERO);
            invoiceDayStatistic.setTotalCnt(Integer.valueOf(0));
            invoiceDayStatistic.setInvalidCnt(Integer.valueOf(0));
            return invoiceDayStatistic;
        }
        BigDecimal totalTaxAmount = invoiceEvents.stream().filter(s -> CONFIRMED.equals(s.getStatus())).map(InvoiceEvent::getTaxAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal invalidAmount = invoiceEvents.stream().filter(s -> INVALID.equals(s.getStatus())).map(InvoiceEvent::getTaxAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
        long totalCnt = invoiceEvents.stream().filter(s -> CONFIRMED.equals(s.getStatus())).count();
        long invalidCnt = invoiceEvents.stream().filter(s -> INVALID.equals(s.getStatus())).count();
        invoiceDayStatistic.setTotalTaxAmount(totalTaxAmount);
        invoiceDayStatistic.setInvalidAmount(invalidAmount);
        invoiceDayStatistic.setTotalCnt(Integer.valueOf((int)totalCnt));
        invoiceDayStatistic.setInvalidCnt(Integer.valueOf((int)invalidCnt));
        invoiceDayStatistic.setStatisticDay(localDate.toString());
        return invoiceDayStatistic;
    }

    public InvoiceMonthStatistic getMonthRealTimeStatistic(String invoiceNature, String monthStatistic) {
        InvoiceMonthStatistic invoiceMonthStatistic = new InvoiceMonthStatistic();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statisticMonth", monthStatistic);
        map.put("invoiceNature", invoiceNature);
        map.put("result", MqCustomerStatus.SUCCESS.name());
        List<InvoiceEvent> invoiceEvents = this.invoiceEventDao.realTimeDateStatistic(map);
        if (CollectionUtils.isEmpty(invoiceEvents)) {
            invoiceMonthStatistic.setStatisticMonth(monthStatistic);
            invoiceMonthStatistic.setTotalTaxAmount(BigDecimal.ZERO);
            invoiceMonthStatistic.setInvalidAmount(BigDecimal.ZERO);
            invoiceMonthStatistic.setTotalCnt(Integer.valueOf(0));
            invoiceMonthStatistic.setInvalidCnt(Integer.valueOf(0));
            return invoiceMonthStatistic;
        }
        BigDecimal totalTaxAmount = invoiceEvents.stream().filter(s -> CONFIRMED.equals(s.getStatus())).map(InvoiceEvent::getTaxAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal invalidAmount = invoiceEvents.stream().filter(s -> INVALID.equals(s.getStatus())).map(InvoiceEvent::getTaxAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
        long totalCnt = invoiceEvents.stream().filter(s -> CONFIRMED.equals(s.getStatus())).count();
        long invalidCnt = invoiceEvents.stream().filter(s -> INVALID.equals(s.getStatus())).count();
        invoiceMonthStatistic.setTotalTaxAmount(totalTaxAmount);
        invoiceMonthStatistic.setInvalidAmount(invalidAmount);
        invoiceMonthStatistic.setTotalCnt(Integer.valueOf((int)totalCnt));
        invoiceMonthStatistic.setInvalidCnt(Integer.valueOf((int)invalidCnt));
        invoiceMonthStatistic.setStatisticMonth(monthStatistic);
        return invoiceMonthStatistic;
    }
}

