/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceMonthStatistic;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceMonthStatisticReq;
import com.rocoinfo.oilcard.batch.api.response.common.InvoiceAmountStatisticResp;
import com.rocoinfo.oilcard.batch.base.utils.MapUtils;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceMonthStatisticDao;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEventHandler;
import com.rocoinfo.oilcard.batch.utils.StatisticUtils;
import java.time.LocalDate;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class InvoiceMonthAmountStatisticHandler
extends BaseSingleTemplate<InvoiceMonthStatisticReq, InvoiceAmountStatisticResp> {
    @Resource
    private InvoiceMonthStatisticDao invoiceMonthStatisticDao;
    @Resource
    private InvoiceEventHandler invoiceEventHandler;

    protected InvoiceAmountStatisticResp callInner(CommonRequest<InvoiceMonthStatisticReq> commonRequest) throws Exception {
        InvoiceMonthStatisticReq req = (InvoiceMonthStatisticReq)commonRequest.getRequest();
        String endMonth = req.getEndMonth();
        Boolean isContainCurrentMonth = StatisticUtils.checkIsContainCurrentMonth(req);
        if (isContainCurrentMonth.booleanValue()) {
            endMonth = StatisticUtils.getMonthYear(LocalDate.now().withDayOfMonth(1).minusMonths(1L));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        MapUtils.putNotNull(params, "startMonth", req.getStartMonth());
        MapUtils.putNotNull(params, "endMonth", endMonth);
        MapUtils.putNotNull(params, "invoiceNature", req.getInvoiceNature());
        InvoiceAmountStatisticResp amount = this.invoiceMonthStatisticDao.getAmount(params);
        if (isContainCurrentMonth.booleanValue()) {
            InvoiceMonthStatistic statistic = this.invoiceEventHandler.getMonthRealTimeStatistic(req.getInvoiceNature(), StatisticUtils.getMonthYear(LocalDate.now()));
            if (amount != null && statistic != null) {
                amount.setInvalidCnt(Integer.valueOf(amount.getInvalidCnt() + statistic.getInvalidCnt()));
                amount.setTotalCnt(Integer.valueOf(amount.getTotalCnt() + statistic.getTotalCnt()));
                amount.setInvalidTaxAmount(amount.getInvalidTaxAmount().add(statistic.getInvalidAmount()));
                amount.setTotalTaxAmount(amount.getTotalTaxAmount().add(statistic.getTotalTaxAmount()));
            } else if (amount == null && statistic != null) {
                InvoiceAmountStatisticResp invoiceAmountStatisticResp = new InvoiceAmountStatisticResp();
                invoiceAmountStatisticResp.setInvalidCnt(statistic.getInvalidCnt());
                invoiceAmountStatisticResp.setTotalCnt(statistic.getTotalCnt());
                invoiceAmountStatisticResp.setInvalidTaxAmount(statistic.getInvalidAmount());
                invoiceAmountStatisticResp.setTotalTaxAmount(statistic.getTotalTaxAmount());
                return invoiceAmountStatisticResp;
            }
        }
        return amount;
    }
}

