/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.job.invoice;

import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceDayStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceMonthStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceTranstionStatistic;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceApplyStatusEnum;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.api.enums.MqCustomerStatus;
import com.rocoinfo.oilcard.batch.base.listener.BatchJobListener;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceDayStatisticDao;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceMonthStatisticDao;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceTranstionStatisticDao;
import com.rocoinfo.oilcard.batch.handler.batch.StepExecutionStatusHandler;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.MySqlPagingQueryProvider;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import tk.mybatis.mapper.entity.Example;

@Configuration
public class InvoiceJobStatistic {
    private static final Logger log = LoggerFactory.getLogger(InvoiceJobStatistic.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private StepExecutionStatusHandler stepExecutionStatusService;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ItemReader<InvoiceEvent> invoiceEventItemReader;
    @Autowired
    private ItemWriter<InvoiceEvent> invoiceEventItemWriter;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceTranstionStatisticDao invoiceTranstionStatisticDao;
    @Autowired
    private InvoiceDayStatisticDao invoiceDayStatisticDao;
    @Autowired
    private InvoiceMonthStatisticDao invoiceMonthStatisticDao;

    @Bean
    public Job cleanInvoiceJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("cleanInvoiceJob").start(this.invoiceCleanStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceCleanStep() {
        return this.stepBuilderFactory.get("invoiceCleanStep").tasklet(new Tasklet(){

            public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
                Map map = chunkContext.getStepContext().getJobParameters();
                String startDateStr = (String)map.get("startDate");
                String endDateStr = (String)map.get("endDate");
                LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                String startMonth = startDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
                String endMonth = endDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
                InvoiceJobStatistic.this.deleteInvoiceDayStatistic(startDateStr, endDateStr);
                InvoiceJobStatistic.this.deleteInvoiceMonthStatistic(startMonth, endMonth);
                InvoiceJobStatistic.this.deleteInvoiceTranstionStatistic(startDateStr, endDateStr);
                return RepeatStatus.FINISHED;
            }
        }).build();
    }

    private void deleteInvoiceDayStatistic(String startDate, String endDate) {
        Example example = new Example(InvoiceDayStatistic.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("statisticDay", (Object)startDate, (Object)endDate);
        this.invoiceDayStatisticDao.deleteByExample(example);
    }

    private void deleteInvoiceMonthStatistic(String startMonth, String endMonth) {
        Example example = new Example(InvoiceMonthStatistic.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("statisticMonth", (Object)startMonth, (Object)endMonth);
        this.invoiceMonthStatisticDao.deleteByExample(example);
    }

    private void deleteInvoiceTranstionStatistic(String startDate, String endDate) {
        Example example = new Example(InvoiceTranstionStatistic.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("statisticDay", (Object)startDate, (Object)endDate);
        this.invoiceTranstionStatisticDao.deleteByExample(example);
    }

    @Bean
    public Job invoiceStatisticDayJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceStatisticDayJob").start(this.invoiceStatisticDayStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceStatisticDayStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceStatistcDayStep").tasklet((stepContribution, chunkContext) -> {
            List<InvoiceTranstionStatistic> invoiceTranstionStatistics = this.invoiceTranstionStatisticDao.statisticTranstionInvoice();
            ArrayList<InvoiceDayStatistic> invoiceDayStatistics = new ArrayList<InvoiceDayStatistic>();
            for (InvoiceTranstionStatistic invoiceTranstionStatistic : invoiceTranstionStatistics) {
                InvoiceDayStatistic invoiceDayStatistic = new InvoiceDayStatistic();
                invoiceDayStatistic.setCreateTime(LocalDateTime.now());
                invoiceDayStatistic.setUpdateTime(LocalDateTime.now());
                invoiceDayStatistic.setInvoiceNature(invoiceTranstionStatistic.getInvoiceNature());
                invoiceDayStatistic.setInvalidAmount(invoiceTranstionStatistic.getInvalidAmount());
                invoiceDayStatistic.setInvalidCnt(invoiceTranstionStatistic.getInvalidCnt());
                invoiceDayStatistic.setTotalTaxAmount(invoiceTranstionStatistic.getTotalTaxAmount());
                invoiceDayStatistic.setTotalCnt(invoiceTranstionStatistic.getTotalCnt());
                invoiceDayStatistic.setStatisticDay(invoiceTranstionStatistic.getStatisticDay());
                invoiceDayStatistic.setStatisticMonth(invoiceTranstionStatistic.getStatisticMonth());
                invoiceDayStatistic.setStatisticYear(invoiceTranstionStatistic.getStatisticYear());
                invoiceDayStatistics.add(invoiceDayStatistic);
            }
            if (invoiceDayStatistics != null && invoiceDayStatistics.size() > 0) {
                this.invoiceDayStatisticDao.batchInsertOrUpdate(invoiceDayStatistics);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean
    public Job invoiceStatisticMonthJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceStatisticMonthJob").start(this.invoiceStatistcMonthStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceStatistcMonthStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceStatistcMonthStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String startDateStr = (String)map.get("startDate");
            String endDateStr = (String)map.get("endDate");
            List<InvoiceMonthStatistic> invoiceMonthStatistics = this.invoiceMonthStatisticDao.statisticMonthByDay(startDateStr, endDateStr);
            invoiceMonthStatistics.forEach(o -> {
                o.setCreateTime(LocalDateTime.now());
                o.setUpdateTime(LocalDateTime.now());
            });
            if (invoiceMonthStatistics != null && invoiceMonthStatistics.size() > 0) {
                this.invoiceMonthStatisticDao.batchInsert(invoiceMonthStatistics);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean
    public Job invoiceStatisticTranstionJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceStatisticTranstionJob").start(this.invoiceStatisticTranstionStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceStatisticTranstionStep() {
        return this.stepBuilderFactory.get("invoiceStatisticTranstionStep").chunk(1000).reader(this.invoiceEventItemReader).writer(this.invoiceEventItemWriter).taskExecutor((TaskExecutor)this.batchTaskExecutor).throttleLimit(2).build();
    }

    @Bean
    @StepScope
    public synchronized ItemReader<InvoiceEvent> invoiceEventItemReader(@Value(value="#{jobParameters[startDate]}") String startDate, @Value(value="#{jobParameters[endDate]}") String endDate) {
        JdbcPagingItemReader reader = new JdbcPagingItemReader();
        reader.setDataSource(this.dataSource);
        reader.setPageSize(500);
        reader.setRowMapper((RowMapper)new InvoiceEventItemRowMapper());
        MySqlPagingQueryProvider queryProvider = new MySqlPagingQueryProvider();
        queryProvider.setSelectClause("*");
        queryProvider.setFromClause("invoice_event");
        HashMap<String, Order> sortKeys = new HashMap<String, Order>(1);
        sortKeys.put("id", Order.ASCENDING);
        queryProvider.setSortKeys(sortKeys);
        queryProvider.setWhereClause("result=:result and confirm_invoice_date between :startDate and :endDate and update_time <= :currentTime");
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("result", MqCustomerStatus.SUCCESS.name());
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("currentTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        reader.setParameterValues(params);
        reader.setQueryProvider((PagingQueryProvider)queryProvider);
        return reader;
    }

    public Map<String, InvoiceTranstionStatistic> getDefault(String startDate, String endDate) {
        List<InvoiceNatureEnum> invoiceNatureEnums = Arrays.asList(InvoiceNatureEnum.BJROCO_BASE_POINT, InvoiceNatureEnum.GZROCO_BASE_POINT, InvoiceNatureEnum.SUPPLIER_BJROCO, InvoiceNatureEnum.SUPPLIER_GZROCO);
        LocalDate startLocalDate = LocalDate.parse(startDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Long dayCnt = endLocalDate.toEpochDay() - startLocalDate.toEpochDay();
        HashMap<String, InvoiceTranstionStatistic> map = new HashMap<String, InvoiceTranstionStatistic>();
        Long i = 0L;
        while (i <= dayCnt) {
            LocalDate day = startLocalDate.plusDays(i);
            for (InvoiceNatureEnum invoiceNatureEnum : invoiceNatureEnums) {
                String statisticDay = day.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                String key = invoiceNatureEnum.name() + statisticDay;
                InvoiceTranstionStatistic invoiceTranstionStatistic = new InvoiceTranstionStatistic();
                invoiceTranstionStatistic.setStatisticDay(statisticDay);
                invoiceTranstionStatistic.setInvoiceNature(invoiceNatureEnum);
                invoiceTranstionStatistic.setStatisticYear(day.format(DateTimeFormatter.ofPattern("yyyy")));
                invoiceTranstionStatistic.setStatisticMonth(day.format(DateTimeFormatter.ofPattern("yyyy-MM")));
                invoiceTranstionStatistic.setUpdateTime(LocalDateTime.now());
                invoiceTranstionStatistic.setCreateTime(LocalDateTime.now());
                invoiceTranstionStatistic.setInvalidCnt(Integer.valueOf(0));
                invoiceTranstionStatistic.setInvalidAmount(BigDecimal.ZERO);
                invoiceTranstionStatistic.setTotalTaxAmount(BigDecimal.ZERO);
                invoiceTranstionStatistic.setTotalCnt(Integer.valueOf(0));
                map.put(key, invoiceTranstionStatistic);
            }
            Long l = i;
            i = i + 1L;
            Long l2 = i;
        }
        return map;
    }

    @Bean
    @StepScope
    public ItemWriter<InvoiceEvent> invoiceEventItemWriter(final @Value(value="#{jobParameters[startDate]}") String startDate, final @Value(value="#{jobParameters[endDate]}") String endDate) {
        try {
            ItemWriter<InvoiceEvent> itemWriter = new ItemWriter<InvoiceEvent>(){

                public void write(List<? extends InvoiceEvent> list) throws Exception {
                    log.info("\u5f00\u59cb\u5904\u7406\u6bcf\u9875\u6570\u636e\u5927\u5c0f\uff1a{}", (Object)list.size());
                    Map<String, List<InvoiceEvent>> map = list.stream().collect(Collectors.groupingBy(o -> o.getInvoiceNature().name() + o.getConfirmInvoiceDate()));
                    Map<String, InvoiceTranstionStatistic> invoiceTranstionStatisticHashMap = InvoiceJobStatistic.this.getDefault(startDate, endDate);
                    map.values().forEach(o -> {
                        InvoiceTranstionStatistic invoiceTranstionStatistic = new InvoiceTranstionStatistic();
                        invoiceTranstionStatistic.setCreateTime(LocalDateTime.now());
                        List invalidInvoices = o.stream().filter(v -> v.getStatus().equals(InvoiceApplyStatusEnum.INVALID.name())).collect(Collectors.toList());
                        List confirmInvoices = o.stream().filter(v -> v.getStatus().equals(InvoiceApplyStatusEnum.CONFIRMED.name())).collect(Collectors.toList());
                        BigDecimal totalAmount = confirmInvoices.stream().map(InvoiceEvent::getTaxAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal invalidTotalAmount = invalidInvoices.stream().map(InvoiceEvent::getTaxAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        invoiceTranstionStatistic.setInvalidAmount(invalidTotalAmount);
                        invoiceTranstionStatistic.setInvalidCnt(Integer.valueOf(invalidInvoices.size()));
                        invoiceTranstionStatistic.setTotalCnt(Integer.valueOf(confirmInvoices.size()));
                        invoiceTranstionStatistic.setTotalTaxAmount(totalAmount);
                        invoiceTranstionStatistic.setInvoiceNature(((InvoiceEvent)o.get(0)).getInvoiceNature());
                        LocalDate confirmInvoiceDate = ((InvoiceEvent)o.get(0)).getConfirmInvoiceDate();
                        String confirmInvoiceDateStr = confirmInvoiceDate.format(DateTimeFormatter.ofPattern("yyy-MM-dd"));
                        invoiceTranstionStatistic.setStatisticDay(confirmInvoiceDateStr);
                        invoiceTranstionStatistic.setStatisticMonth(confirmInvoiceDate.format(DateTimeFormatter.ofPattern("yyyy-MM")));
                        invoiceTranstionStatistic.setStatisticYear(confirmInvoiceDate.format(DateTimeFormatter.ofPattern("yyyy")));
                        invoiceTranstionStatistic.setUpdateTime(LocalDateTime.now());
                        String key = invoiceTranstionStatistic.getInvoiceNature().name() + invoiceTranstionStatistic.getStatisticDay();
                        invoiceTranstionStatisticHashMap.put(key, invoiceTranstionStatistic);
                    });
                    InvoiceJobStatistic.this.invoiceTranstionStatisticDao.batchInsert(new ArrayList<InvoiceTranstionStatistic>(invoiceTranstionStatisticHashMap.values()));
                }
            };
            return itemWriter;
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u7edf\u8ba1\u6279\u5904\u7406\u8fc7\u6e21\u6570\u636e\u5165\u5e93\u5931\u8d25:{}", (Throwable)e);
            return null;
        }
    }

    protected class InvoiceEventItemRowMapper
    implements RowMapper<InvoiceEvent> {
        protected InvoiceEventItemRowMapper() {
        }

        public InvoiceEvent mapRow(ResultSet resultSet, int i) throws SQLException {
            InvoiceEvent invoiceEvent = new InvoiceEvent();
            invoiceEvent.setId(Long.valueOf(resultSet.getLong("id")));
            invoiceEvent.setInvoiceNature(InvoiceNatureEnum.valueOf((String)resultSet.getString("invoice_nature")));
            invoiceEvent.setConfirmInvoiceDate(resultSet.getDate("confirm_invoice_date").toLocalDate());
            invoiceEvent.setTaxAccount(resultSet.getBigDecimal("tax_account"));
            invoiceEvent.setStatus(resultSet.getString("status"));
            return invoiceEvent;
        }
    }
}

