/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.schedule;

import com.rocogz.common.api.request.CommonRequest;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEventDao;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceJobStatisticStartHandler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InvoiceJobSchedule {
    private static final Logger log = LoggerFactory.getLogger(InvoiceJobSchedule.class);
    @Autowired
    private InvoiceJobStatisticStartHandler invoiceJobStatisticStartHandler;
    @Autowired
    private InvoiceEventDao invoiceEventDao;

    @Scheduled(cron="0 5 0 * * ?")
    public void invoiceStatistic() {
        log.info("invoiceStatistic \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb=====");
        CommonRequest request = new CommonRequest();
        InvoiceJobReq invoiceJobReq = new InvoiceJobReq();
        String currentDay = LocalDate.now().plusDays(-1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Map map = this.invoiceEventDao.selectConfirmInvoiceDate(currentDay + " 00:00:00", currentDay + " 23:59:59");
        if (map != null && map.size() > 0) {
            String maxConfirmInvoiceDate = map.get("max_confirm_invoice_date").toString();
            String minConfirmInvoiceDate = map.get("min_confirm_invoice_date").toString();
            invoiceJobReq.setStartDate(LocalDate.parse(minConfirmInvoiceDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            invoiceJobReq.setEndDate(LocalDate.parse(maxConfirmInvoiceDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            request.setRequest((Object)invoiceJobReq);
            this.invoiceJobStatisticStartHandler.call(request);
        }
        log.info("invoiceStatistic \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f=====");
    }
}

