/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.base.job;

import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.JobLauncher;

public class StartBatchJob
implements Runnable {
    private JobLauncher jobLauncher;
    private Map<Integer, Job> jobNameMap;
    private JobParameters jobParameters;

    public StartBatchJob(JobLauncher jobLauncher, Map<Integer, Job> jobNameMap, JobParameters jobParameters) {
        this.jobLauncher = jobLauncher;
        this.jobNameMap = jobNameMap;
        this.jobParameters = jobParameters;
    }

    @Override
    public void run() {
        boolean executorFlag = true;
        int executionSteps = 1;
        if (this.jobNameMap != null) {
            Job job;
            while ((job = (Job)this.jobNameMap.get(executionSteps)) != null && executorFlag) {
                executorFlag = this.startJob(job, this.jobParameters);
                ++executionSteps;
            }
        }
    }

    private boolean startJob(Job jobName, JobParameters jobParameters) {
        JobExecution jobExecution = null;
        try {
            jobExecution = this.jobLauncher.run(jobName, jobParameters);
            return "COMPLETED".equals(jobExecution.getExitStatus().getExitCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

