/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.base.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    public static final String YYYY_MM = "yyyyMM";
    public static final String YYYY__MM = "yyyy-MM";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String DATE_KEY_STR = "yyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String START_TIME = " 00:00:00";
    public static final String END_TIME = " 23:59:59";

    public static Date parseToDateTime(String strDate) {
        return DateUtil.parse((String)strDate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseToDate(String strDate) {
        return DateUtil.parse((String)strDate, (String)"yyyy-MM-dd");
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int compareDateWithNow(Date date) {
        return DateUtil.compareDate((Date)date, (Date)new Date());
    }

    public static int compareDate(Date date1, Date date2) {
        int rnum = date1.compareTo(date2);
        return rnum;
    }

    public static Long compareDate(String beginTime, String endTime) {
        SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date begin = dfs.parse(beginTime);
            Date end = dfs.parse(endTime);
            long between = (end.getTime() - begin.getTime()) / 1000L;
            return between;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int compareDateWithNow(long date) {
        long now = DateUtil.dateToUnixTimestamp();
        if (date > now) {
            return 1;
        }
        if (date < now) {
            return -1;
        }
        return 0;
    }

    public static String getNowTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    public static String getNowTime(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(new Date());
    }

    public static Date addDays(Date paramDate, int paramInt) {
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTime(paramDate);
        int i = localCalendar.get(6);
        localCalendar.set(6, i + paramInt);
        return localCalendar.getTime();
    }

    public static String getJFPTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        return df.format(new Date());
    }

    public static long format(String date) {
        long timestamp = 0L;
        try {
            timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static long format(String date, String pattern) {
        long timestamp = 0L;
        try {
            timestamp = new SimpleDateFormat(pattern).parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static String format(Date date, String pattern) {
        String timestamp = "0";
        try {
            timestamp = new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static long dateToUnixTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp;
    }

    public static String unixTimestampToDate(long timestamp) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sd.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        return sd.format(new Date(timestamp));
    }

    public static Date addNDate(Date date, int n) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date == null ? new Date() : date);
        c1.add(5, n);
        return c1.getTime();
    }

    public static Date currentMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date monthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date monthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date weekFirstDay(Date date) {
        int dayOfWeek;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        int offset = (dayOfWeek = calendar.get(7)) == 1 ? -6 : 2 - dayOfWeek;
        calendar.add(7, offset);
        return calendar.getTime();
    }

    public static Date weekLastDay(Date date) {
        int dayOfWeek;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        int offset = (dayOfWeek = calendar.get(7)) == 1 ? 0 : 7 - dayOfWeek + 1;
        calendar.add(7, offset);
        return calendar.getTime();
    }

    public static LocalDate parseToLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static String getUpMonth(String formatStr) {
        Calendar cale = Calendar.getInstance();
        cale.setTime(new Date());
        cale.set(5, 0);
        return DateUtil.formatDate((String)formatStr, (String)DateUtil.format((Date)cale.getTime(), (String)"yyyy-MM-dd"));
    }

    public static String getCurrentMonthLastDay(String date, String formatStr) {
        Calendar cale = Calendar.getInstance();
        cale.setTime(DateUtil.parseToDate((String)date));
        cale.add(2, 1);
        cale.set(5, 0);
        return DateUtil.formatDate((String)DateUtil.format((Date)cale.getTime(), (String)formatStr), (String)formatStr);
    }

    public static String formatDate(String dateStr, String formatStr) {
        return new SimpleDateFormat(formatStr).format(DateUtil.parseToDateTime((String)dateStr));
    }

    public static List<String> getDaySection(String startTimeStr, String endTimeStr, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            Date startTime = sdf.parse(startTimeStr);
            Date endTime = sdf.parse(endTimeStr);
            List dateSection = DateUtil.getDaySection((Date)startTime, (Date)endTime);
            ArrayList<String> sectionStr = new ArrayList<String>(dateSection.size());
            for (Date date : dateSection) {
                sectionStr.add(sdf.format(date));
            }
            return sectionStr;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Date> getDaySection(Date startTime, Date endTime) {
        ArrayList<Date> section = new ArrayList<Date>();
        section.add(startTime);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        while (startCal.getTime().before(endTime)) {
            startCal.setTimeInMillis(startCal.getTimeInMillis() + 86400000L);
            section.add(startCal.getTime());
        }
        return section;
    }

    public static List<String> getMonthSection(String startTimeStr, String endTimeStr, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            Date startTime = sdf.parse(startTimeStr);
            Date endTime = sdf.parse(endTimeStr);
            List dateSection = DateUtil.getMonthSection((Date)startTime, (Date)endTime);
            ArrayList<String> sectionStr = new ArrayList<String>(dateSection.size());
            for (Date date : dateSection) {
                sectionStr.add(sdf.format(date));
            }
            return sectionStr;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Date> getMonthSection(Date startTime, Date endTime) {
        ArrayList<Date> section = new ArrayList<Date>();
        section.add(startTime);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        while (startCal.getTime().before(endTime)) {
            startCal.add(2, 1);
            section.add(startCal.getTime());
        }
        return section;
    }

    public static Date localDateTimeToDate(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateToDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime dateToLocalDateTime(Date time) {
        if (time == null) {
            return null;
        }
        return LocalDateTime.ofInstant(time.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate dateToLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate formatDateStrToLocalDate(String dateStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return LocalDate.parse(dateStr, df);
    }

    public static Date minusDays(Date date, int i) {
        if (date == null) {
            return null;
        }
        return DateUtil.localDateToDate((LocalDate)DateUtil.dateToLocalDate((Date)date).minusDays(i));
    }

    public static String addYear(String dateIn, int years) {
        Date date = StringUtils.isEmpty((CharSequence)dateIn) ? new Date() : DateUtil.parseToDate((String)dateIn);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).plusYears(years);
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static Date getNowTimeDateObj(String pattern) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.parse(df.format(new Date()));
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static LocalDate formatLocalDateByPattern(String date, String pattern) {
        if (date == null) {
            return null;
        }
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(pattern));
    }
}

