/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.base.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static int getWeekCntByDate(String date) {
        return DateUtils.getWeekCntByDate((LocalDate)LocalDate.parse(date));
    }

    public static int getWeekCntByDate(LocalDate localDate) {
        String dateStr = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        int currentDay = localDate.getDayOfMonth();
        int days = localDate.withMonth(localDate.getMonth().getValue()).lengthOfMonth();
        String firstDate = dateStr.substring(0, 7) + "-01";
        LocalDate firstLocalDate = LocalDate.parse(firstDate);
        int firstDayWeek = firstLocalDate.getDayOfWeek().getValue();
        String endDate = dateStr.substring(0, 7) + "-" + days;
        LocalDate endLocalDate = LocalDate.parse(endDate);
        int endDayWeek = endLocalDate.getDayOfWeek().getValue();
        int weekCnt = (days - (7 - firstDayWeek + 1) - endDayWeek) / 7 + 2;
        HashMap<Integer, Integer> weekDayMap = new HashMap<Integer, Integer>();
        weekDayMap.put(1, 7 - firstDayWeek + 1);
        for (int i = 2; i < weekCnt; ++i) {
            weekDayMap.put(i, 7 - firstDayWeek + 1 + (i - 1) * 7);
        }
        weekDayMap.put(weekCnt, days);
        for (Integer week : weekDayMap.keySet()) {
            int weekDayRange = (Integer)weekDayMap.get(week);
            if (currentDay > weekDayRange) continue;
            return week;
        }
        return -1;
    }

    public static String getTimeStr(LocalDateTime time, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return time.format(formatter);
    }
}

